/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.ParameterDumper;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;

public class MethodDumper
extends Dumper<MethodEntity> {
    protected ParameterDumper parameterDumper;

    protected MethodDumper(Context context, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
        this.parameterDumper = new ParameterDumper(this.context, this.env, this.debugInformation);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void save(MethodEntity entity, OutputStream output) throws IOException {
        DumpOutputStream print = new DumpOutputStream(output);
        DocumentComment docComment = entity.getDocComment();
        if (docComment != null) {
            print.writeUTF(docComment.toString());
        } else {
            print.writeUTF("");
        }
        print.writeBoolean(entity.isStatic());
        print.writeBoolean(entity.isFinal());
        print.writeBoolean(entity.isAbstract());
        print.writeBoolean(entity.isAbstractable());
        print.writeBoolean(entity.isImmutable());
        print.writeMemory(entity.getImmutableResult());
        print.writeBoolean(entity.isEmpty());
        print.writeBoolean(entity.isReturnReference());
        print.writeBoolean(entity.isUsesStackTrace());
        print.writeEnum(entity.getModifier());
        print.writeName(entity.getName());
        print.writeName(entity.getInternalName());
        print.writeTrace(this.debugInformation ? entity.getTrace() : null);
        print.writeInt(entity.getParameters() == null ? 0 : entity.getParameters().length);
        if (entity.getParameters() != null) {
            for (ParameterEntity param : entity.getParameters()) {
                this.parameterDumper.save(param, output);
            }
        }
        print.writeRawData(null);
    }

    @Override
    public MethodEntity load(InputStream input) throws IOException {
        DumpInputStream data = new DumpInputStream(input);
        MethodEntity entity = new MethodEntity(this.context);
        String docComment = data.readUTF();
        if (!docComment.isEmpty()) {
            entity.setDocComment(new DocumentComment(docComment));
        }
        entity.setStatic(data.readBoolean());
        entity.setFinal(data.readBoolean());
        entity.setAbstract(data.readBoolean());
        entity.setAbstractable(data.readBoolean());
        entity.setImmutable(data.readBoolean());
        entity.setResult(data.readMemory());
        entity.setEmpty(data.readBoolean());
        entity.setReturnReference(data.readBoolean());
        entity.setUsesStackTrace(data.readBoolean());
        entity.setModifier(data.readModifier());
        entity.setName(data.readName());
        entity.setInternalName(data.readName());
        entity.setTrace(data.readTrace(this.context));
        int paramCount = data.readInt();
        if (paramCount < 0) {
            throw new DumpException("Invalid param count");
        }
        entity.setParameters(new ParameterEntity[paramCount]);
        for (int i = 0; i < paramCount; ++i) {
            ParameterEntity param = this.parameterDumper.load(input);
            param.setTrace(entity.getTrace());
            entity.getParameters()[i] = param;
        }
        data.readRawData();
        return entity;
    }
}

