/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.loader.dump.ConstantDumper;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.MethodDumper;
import php.runtime.loader.dump.PropertyDumper;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.PropertyEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class ClassDumper
extends Dumper<ClassEntity> {
    protected final PropertyDumper propertyDumper;
    protected final ConstantDumper constantDumper;
    protected final MethodDumper methodDumper;
    protected final ModuleEntity module;

    public ClassDumper(Context context, ModuleEntity module, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
        this.propertyDumper = new PropertyDumper(this.context, this.env, this.debugInformation);
        this.constantDumper = new ConstantDumper(this.context, this.env, this.debugInformation);
        this.methodDumper = new MethodDumper(this.context, this.env, this.debugInformation);
        this.module = module;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void save(ClassEntity entity, OutputStream output) throws IOException {
        if (entity.getType() == ClassEntity.Type.CLASS && entity.getData() == null) {
            throw new DumpException("Class '" + entity.getName() + "' not compiled");
        }
        DumpOutputStream printer = new DumpOutputStream(output);
        printer.writeBoolean(entity.isStatic());
        printer.writeEnum(entity.getType());
        printer.writeBoolean(entity.isAbstract());
        printer.writeBoolean(entity.isFinal());
        printer.writeName(entity.getName());
        printer.writeName(entity.getCompiledInternalName());
        printer.writeTrace(this.debugInformation ? entity.getTrace() : null);
        ClassEntity parent = entity.getParent();
        if (entity.getParent() != null) {
            printer.writeName(parent.getName());
        } else {
            printer.writeName(null);
        }
        ArrayList<ConstantEntity> constants = new ArrayList<ConstantEntity>();
        for (ConstantEntity constantEntity : entity.getConstants()) {
            if (!constantEntity.isOwned(entity)) continue;
            constants.add(constantEntity);
        }
        printer.writeInt(constants.size());
        for (ConstantEntity constantEntity : constants) {
            this.constantDumper.save(constantEntity, output);
        }
        ArrayList<PropertyEntity> properties = new ArrayList<PropertyEntity>();
        for (PropertyEntity el : entity.getStaticProperties()) {
            if (!el.isOwned(entity)) continue;
            properties.add(el);
        }
        for (PropertyEntity el : entity.getProperties()) {
            if (!el.isOwned(entity)) continue;
            properties.add(el);
        }
        printer.writeInt(properties.size());
        for (PropertyEntity el : properties) {
            this.propertyDumper.save(el, output);
        }
        printer.writeInt(entity.getMethodCounts());
        List<MethodEntity> list = entity.getOwnedMethods();
        printer.writeInt(list.size());
        for (MethodEntity methodEntity : list) {
            this.methodDumper.save(methodEntity, output);
        }
        printer.writeInt(entity.getInterfaces().size());
        for (ClassEntity classEntity : entity.getInterfaces().values()) {
            printer.writeName(classEntity.getName());
        }
        printer.writeInt(entity.getTraits().size());
        for (ClassEntity classEntity : entity.getTraits().values()) {
            printer.writeName(classEntity.getName());
        }
        if (this.includeData) {
            printer.writeRawData(entity.getData(), Integer.MAX_VALUE);
        } else {
            printer.writeRawData(null);
        }
        printer.writeRawData(null);
    }

    @Override
    public ClassEntity load(InputStream input) throws IOException {
        return this.load(input, ClassEntity.class);
    }

    public <T extends ClassEntity> T load(InputStream input, Class<T> clazz) throws IOException {
        DumpInputStream data = new DumpInputStream(input);
        ClassEntity entity = null;
        try {
            entity = (ClassEntity)clazz.getConstructor(Context.class).newInstance(this.context);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        entity.setId(this.env.scope.nextClassIndex());
        entity.setStatic(data.readBoolean());
        entity.setType(data.readClassType());
        entity.setAbstract(data.readBoolean());
        entity.setFinal(data.readBoolean());
        entity.setName(data.readName());
        entity.setInternalName(data.readName());
        entity.setTrace(data.readTrace(this.context));
        String parent = data.readName();
        if (parent != null) {
            ClassEntity parentEntity;
            ClassEntity classEntity = parentEntity = this.module == null ? null : this.module.findClass(parent);
            if (parentEntity == null) {
                parentEntity = this.env.fetchClass(parent, true);
            }
            if (parentEntity == null) {
                this.env.error(this.env.trace(), ErrorType.E_ERROR, Messages.ERR_CLASS_NOT_FOUND, parent);
            } else {
                ClassEntity.ExtendsResult result = entity.setParent(parentEntity, false);
                if (clazz != GeneratorEntity.class) {
                    result.check(this.env);
                }
            }
        }
        int constantCount = data.readInt();
        for (int i = 0; i < constantCount; ++i) {
            ConstantEntity el = this.constantDumper.load(input);
            el.setClazz(entity);
            entity.addConstant(el);
        }
        int propertyCount = data.readInt();
        for (int i = 0; i < propertyCount; ++i) {
            PropertyEntity el = this.propertyDumper.load(input);
            el.setClazz(entity);
            ClassEntity.PropertyResult result = entity.addProperty(el);
            result.check(this.env);
        }
        entity.__setMethodCounts(data.readInt());
        int methodCount = data.readInt();
        for (int i = 0; i < methodCount; ++i) {
            MethodEntity el = this.methodDumper.load(input);
            el.setClazz(entity);
            ClassEntity.SignatureResult result = entity.addMethod(el, null);
            result.check(this.env);
        }
        entity.updateParentMethods().check(this.env);
        int interfaceCount = data.readInt();
        for (int i = 0; i < interfaceCount; ++i) {
            ClassEntity interfaceEntity;
            String name = data.readName();
            ClassEntity classEntity = interfaceEntity = this.module == null ? null : this.module.findClass(name);
            if (interfaceEntity == null) {
                interfaceEntity = this.env.fetchClass(name, true);
            }
            if (interfaceEntity == null) {
                this.env.error(this.env.trace(), ErrorType.E_ERROR, Messages.ERR_INTERFACE_NOT_FOUND, name);
            }
            ClassEntity.ImplementsResult result = entity.addInterface(interfaceEntity);
            result.check(this.env);
        }
        int traitCount = data.readInt();
        for (int i = 0; i < traitCount; ++i) {
            ClassEntity traitEntity;
            String name = data.readName();
            ClassEntity classEntity = traitEntity = this.module == null ? null : this.module.findClass(name);
            if (traitEntity == null) {
                traitEntity = this.env.fetchClass(name, true);
            }
            if (traitEntity == null) {
                this.env.error(this.env.trace(), ErrorType.E_ERROR, Messages.ERR_TRAIT_NOT_FOUND, name);
            } else if (!traitEntity.isTrait()) {
                this.env.error(this.env.trace(), ErrorType.E_ERROR, Messages.ERR_CANNOT_USE_NON_TRAIT, name);
            }
            entity.addTrait(traitEntity);
        }
        entity.setData(data.readRawData(Integer.MAX_VALUE));
        data.readRawData();
        entity.doneDeclare();
        return (T)entity;
    }
}

