/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.lang;

import java.util.Iterator;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public abstract class ForeachIterator
implements Iterable<Memory> {
    protected Object currentKey;
    protected Memory currentKeyMemory;
    protected Memory currentValue;
    protected boolean init = false;
    protected final boolean getReferences;
    protected final boolean getKeyReferences;
    protected final boolean withPrevious;
    protected boolean plainReferences = false;
    protected TraceInfo trace = TraceInfo.UNKNOWN;

    protected abstract boolean init();

    protected abstract boolean nextValue();

    protected abstract boolean prevValue();

    public static ForeachIterator of(final Environment env, final Map map) {
        return new ForeachIterator(false, false, false){
            private Iterator<Map.Entry<Object, Object>> entries;

            @Override
            protected boolean init() {
                this.reset();
                return !map.isEmpty();
            }

            @Override
            protected boolean nextValue() {
                if (this.entries.hasNext()) {
                    Map.Entry<Object, Object> entry = this.entries.next();
                    this.currentKey = entry.getKey();
                    this.currentKeyMemory = this.currentKey == null ? Memory.NULL : StringMemory.valueOf(this.currentKey.toString());
                    this.currentValue = Memory.wrap(env, entry.getValue());
                    if (!this.getReferences) {
                        this.currentValue = this.currentValue.toValue();
                    }
                    return true;
                }
                return false;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public void reset() {
                this.entries = map.entrySet().iterator();
            }
        };
    }

    public static ForeachIterator of(final Environment env, final Iterable iterable) {
        return new ForeachIterator(false, false, false){
            protected Iterator iterator;

            @Override
            protected boolean init() {
                this.iterator = iterable.iterator();
                this.currentKeyMemory = LongMemory.CONST_INT_M1;
                this.currentKey = this.currentKeyMemory.toLong();
                return true;
            }

            @Override
            protected boolean nextValue() {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                Object next = this.iterator.next();
                this.currentKeyMemory = this.currentKeyMemory == null ? Memory.CONST_INT_0 : this.currentKeyMemory.inc();
                this.currentKey = this.currentKeyMemory.toLong();
                this.currentValue = Memory.wrap(env, next);
                return true;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public void reset() {
                this.iterator = iterable.iterator();
            }
        };
    }

    public ForeachIterator(boolean getReferences, boolean getKeyReferences, boolean withPrevious) {
        this.getReferences = getReferences;
        this.withPrevious = withPrevious;
        this.getKeyReferences = getKeyReferences;
    }

    public void setPlainReferences(boolean plainReferences) {
        this.plainReferences = plainReferences;
    }

    public boolean prev() {
        this.currentKeyMemory = null;
        if (!this.init || !this.withPrevious) {
            this.currentKey = null;
            this.currentValue = null;
            return false;
        }
        return this.prevValue();
    }

    public boolean next() {
        this.currentKeyMemory = null;
        if (!this.init) {
            this.init = true;
            if (!this.init()) {
                return false;
            }
        }
        return this.nextValue();
    }

    public boolean end() {
        return false;
    }

    public Object getKey() {
        return this.currentKey;
    }

    public String getStringKey() {
        Object key = this.getKey();
        return key == null ? null : key.toString();
    }

    public abstract void reset();

    public boolean isLongKey() {
        return this.currentKey instanceof Long || this.currentKey instanceof Memory && ((Memory)this.currentKey).isNumber();
    }

    public Memory getMemoryKey() {
        if (this.currentKeyMemory != null) {
            return this.currentKeyMemory;
        }
        if (this.currentKey instanceof String) {
            this.currentKeyMemory = new StringMemory((String)this.currentKey);
            return this.currentKeyMemory;
        }
        if (this.currentKey instanceof Long) {
            this.currentKeyMemory = LongMemory.valueOf((Long)this.currentKey);
            return this.currentKeyMemory;
        }
        if (this.currentKey instanceof Memory) {
            this.currentKeyMemory = (Memory)this.currentKey;
            return this.currentKeyMemory;
        }
        this.currentKeyMemory = Memory.NULL;
        return this.currentKeyMemory;
    }

    public Memory getValue() {
        return this.currentValue;
    }

    public TraceInfo getTrace() {
        return this.trace;
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    @Override
    public Iterator<Memory> iterator() {
        return new Iterator<Memory>(){
            protected Boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    this.hasNext = ForeachIterator.this.next();
                }
                return this.hasNext;
            }

            @Override
            public Memory next() {
                if (this.hasNext != null) {
                    this.hasNext = null;
                    return ForeachIterator.this.getValue();
                }
                ForeachIterator.this.next();
                return ForeachIterator.this.getValue();
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Unsupported remove() method");
            }
        };
    }
}

