/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.support;

import java.util.LinkedHashMap;
import java.util.Map;
import php.runtime.annotation.Reflection;
import php.runtime.common.collections.map.HashedMap;
import php.runtime.env.CompileScope;
import php.runtime.env.Environment;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.java.JavaException;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.ext.support.compile.CompileFunctionSpec;
import php.runtime.ext.support.compile.ConstantsContainer;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.IObject;
import php.runtime.memory.support.MemoryOperation;

public abstract class Extension {
    protected final Map<String, CompileConstant> constants = new LinkedHashMap<String, CompileConstant>();
    protected final Map<String, CompileFunctionSpec> functions = new LinkedHashMap<String, CompileFunctionSpec>();
    protected final Map<String, Class<?>> classes = new LinkedHashMap();

    public String getName() {
        return this.getClass().getName();
    }

    public String getVersion() {
        return "0.9.0";
    }

    public abstract Status getStatus();

    @Deprecated
    public String[] getRequiredExtensions() {
        return new String[0];
    }

    @Deprecated
    public String[] getOptionalExtensions() {
        return new String[0];
    }

    @Deprecated
    public String[] getConflictExtensions() {
        return new String[0];
    }

    public Map<String, String> getINIEntries() {
        return new HashedMap<String, String>();
    }

    public abstract void onRegister(CompileScope var1);

    public void onLoad(Environment env) {
    }

    public Map<String, CompileConstant> getConstants() {
        return this.constants;
    }

    public Map<String, CompileFunctionSpec> getFunctions() {
        return this.functions;
    }

    public Map<String, Class<?>> getClasses() {
        return this.classes;
    }

    @Deprecated
    public void registerNativeClass(CompileScope scope, Class<?> clazz) {
        this.registerClass(scope, clazz);
    }

    public void registerClass(CompileScope scope, Class<?> clazz) {
        if (BaseWrapper.class.isAssignableFrom(clazz) && !clazz.isAnnotationPresent(Reflection.NotWrapper.class)) {
            throw new CriticalException("Please use registerWrapperClass() method instead of this for wrapper classes");
        }
        if (this.classes.put(clazz.getName(), clazz) != null) {
            throw new CriticalException("Class already registered - " + clazz.getName());
        }
    }

    public <T> void registerWrapperClass(CompileScope scope, Class<T> clazz, Class<? extends BaseWrapper> wrapperClass) {
        if (this.classes.put(clazz.getName(), wrapperClass) != null) {
            throw new CriticalException("Class already registered - " + clazz.getName());
        }
        MemoryOperation.registerWrapper(clazz, wrapperClass);
    }

    public void registerMemoryOperation(Class<? extends MemoryOperation> clazz) {
        try {
            MemoryOperation.register(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CriticalException(e);
        }
    }

    public void registerJavaException(CompileScope scope, Class<? extends JavaException> javaClass, Class<? extends Throwable> ... classes) {
        this.registerClass(scope, javaClass);
        if (classes != null) {
            for (Class<? extends Throwable> el : classes) {
                scope.registerJavaException(javaClass, el);
            }
        }
    }

    public void registerJavaExceptionForContext(CompileScope scope, Class<? extends JavaException> javaClass, Class<? extends IObject> context) {
        this.registerClass(scope, javaClass);
        scope.registerJavaExceptionForContext(javaClass, context);
    }

    public void registerConstants(ConstantsContainer container) {
        for (CompileConstant constant : container.getConstants()) {
            this.constants.put(constant.name, constant);
        }
    }

    public void registerFunctions(FunctionsContainer container) {
        for (CompileFunctionSpec function : container.getFunctionSpecs()) {
            this.functions.put(function.getLowerName(), function);
        }
    }

    public static interface Extensible {
        public Extension getExtension();
    }

    public static enum Status {
        EXPERIMENTAL,
        BETA,
        STABLE,
        LEGACY,
        ZEND_LEGACY,
        DEPRECATED;

    }
}

