/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionExtension;
import php.runtime.ext.core.reflection.ReflectionMethod;
import php.runtime.ext.core.reflection.ReflectionProperty;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.PropertyEntity;

@Reflection.Name(value="ReflectionClass")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true)})
public class ReflectionClass
extends Reflection {
    public static final int IS_IMPLICIT_ABSTRACT = 16;
    public static final int IS_EXPLICIT_ABSTRACT = 32;
    public static final int IS_FINAL = 64;
    protected ClassEntity entity;

    protected ReflectionClass(Environment env) {
        super(env);
    }

    public ReflectionClass(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ReflectionClass setEntity(ClassEntity entity) {
        this.entity = entity;
        this.getProperties().put("name", new StringMemory(entity.getName()));
        return this;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="argument")})
    public Memory __construct(Environment env, Memory ... args) {
        Memory argument = args[0];
        if (argument.isObject()) {
            this.entity = argument.toValue(ObjectMemory.class).getReflection();
        } else {
            this.entity = env.fetchClass(argument.toString(), true);
            if (this.entity == null) {
                this.exception(env, Messages.ERR_CLASS_NOT_FOUND.fetch(argument.toString()), new Object[0]);
            }
        }
        this.setEntity(this.entity);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.entity.getName());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getConstant(Environment env, Memory ... args) {
        ConstantEntity constantEntity = this.entity.findConstant(args[0].toString());
        if (constantEntity == null) {
            return Memory.FALSE;
        }
        return constantEntity.getValue(env);
    }

    @Reflection.Signature
    public Memory getConstants(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (ConstantEntity e : this.entity.getConstants()) {
            result.put(e.getName(), e.getValue(env));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getDefaultProperties(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (PropertyEntity e : this.entity.getStaticProperties()) {
            result.put(e.getName(), e.getDefaultValue(env));
        }
        for (PropertyEntity e : this.entity.getProperties()) {
            result.put(e.getName(), e.getDefaultValue(env));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getDocComment(Environment env, Memory ... args) {
        if (this.entity.getDocComment() == null) {
            return Memory.NULL;
        }
        return new StringMemory(this.entity.getDocComment().toString());
    }

    @Reflection.Signature
    public Memory getEndLine(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.entity.getTrace().getEndLine());
    }

    @Reflection.Signature
    public Memory getExtension(Environment env, Memory ... args) {
        if (this.entity.getExtension() == null) {
            return Memory.NULL;
        }
        ReflectionExtension extension = new ReflectionExtension(env);
        extension.setExtension(this.entity.getExtension());
        return new ObjectMemory(extension);
    }

    @Reflection.Signature
    public Memory getExtensionName(Environment env, Memory ... args) {
        if (this.entity.getExtension() == null) {
            return Memory.FALSE;
        }
        return new StringMemory(this.entity.getExtension().getName());
    }

    @Reflection.Signature
    public Memory getFileName(Environment env, Memory ... args) {
        if (this.entity.isInternal()) {
            return Memory.FALSE;
        }
        return new StringMemory(this.entity.getTrace().getFileName());
    }

    @Reflection.Signature
    public Memory getInterfaceNames(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (ClassEntity e : this.entity.getInterfaces().values()) {
            result.add(new StringMemory(e.getName()));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getInterfaces(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        ClassEntity classEntity = env.fetchClass("ReflectionClass");
        for (ClassEntity e : this.entity.getInterfaces().values()) {
            ReflectionClass cls = new ReflectionClass(env, classEntity);
            cls.setEntity(e);
            result.add(new ObjectMemory(cls));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getConstructor(Environment env, Memory ... args) {
        return this.entity.methodConstruct == null ? Memory.NULL : new ObjectMemory(new ReflectionMethod(env, this.entity.methodConstruct));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getMethod(Environment env, Memory ... args) {
        MethodEntity m = this.entity.findMethod(args[0].toString().toLowerCase());
        if (m == null) {
            this.exception(env, Messages.ERR_METHOD_NOT_FOUND.fetch(this.entity.getName(), args[0]), new Object[0]);
            return Memory.NULL;
        }
        ReflectionMethod r = new ReflectionMethod(env, m);
        return new ObjectMemory(r);
    }

    private boolean checkModifiers(MethodEntity e, int mod) {
        if (mod == -1) {
            return true;
        }
        if (e.isStatic() && (mod & 1) == 1) {
            return true;
        }
        if (e.isFinal() && (mod & 4) == 4) {
            return true;
        }
        if (e.isAbstract() && (mod & 2) == 2) {
            return true;
        }
        switch (e.getModifier()) {
            case PRIVATE: {
                return (mod & 0x400) == 1024;
            }
            case PROTECTED: {
                return (mod & 0x200) == 512;
            }
            case PUBLIC: {
                return (mod & 0x100) == 256;
            }
        }
        return false;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", optional=@Reflection.Optional(value="NULL"))})
    public Memory getMethods(Environment env, Memory ... args) {
        int mod = args[0].isNull() ? -1 : args[0].toInteger();
        ArrayMemory result = new ArrayMemory();
        ClassEntity classEntity = env.fetchClass("ReflectionMethod");
        for (MethodEntity e : this.entity.getMethods().values()) {
            if (!this.checkModifiers(e, mod)) continue;
            ReflectionMethod method = new ReflectionMethod(env, classEntity);
            method.setEntity(e);
            result.add(new ObjectMemory(method));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        int mod = 0;
        if (this.entity.isFinal()) {
            mod |= 0x40;
        }
        if (this.entity.isAbstract()) {
            mod |= 0x20;
        }
        return LongMemory.valueOf(mod);
    }

    @Reflection.Signature
    public Memory getNamespaceName(Environment env, Memory ... args) {
        if (!this.entity.isNamespace()) {
            return Memory.FALSE;
        }
        return new StringMemory(this.entity.getNamespaceName());
    }

    @Reflection.Signature
    public Memory getShortName(Environment env, Memory ... args) {
        return new StringMemory(this.entity.getShortName());
    }

    @Reflection.Signature
    public Memory isNamespace(Environment env, Memory ... args) {
        return this.entity.isNamespace() ? Memory.TRUE : Memory.FALSE;
    }

    private boolean checkModifiers(PropertyEntity prop, int mod) {
        boolean add;
        boolean bl = add = mod == -1;
        if (!add) {
            switch (prop.getModifier()) {
                case PRIVATE: {
                    add = (mod & 0x400) == 1024;
                    break;
                }
                case PROTECTED: {
                    add = (mod & 0x200) == 512;
                    break;
                }
                case PUBLIC: {
                    add = (mod & 0x100) == 256;
                }
            }
        }
        return add;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getProperty(Environment env, Memory ... args) {
        String name = args[0].toString();
        PropertyEntity e = this.entity.findProperty(name);
        if (e == null) {
            e = this.entity.findStaticProperty(name);
        }
        if (e == null) {
            return Memory.NULL;
        }
        ClassEntity classEntity = env.fetchClass("ReflectionProperty");
        ReflectionProperty prop = new ReflectionProperty(env, classEntity);
        prop.setEntity(e);
        return new ObjectMemory(prop);
    }

    @Reflection.Signature
    public Memory getStaticProperties(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        ClassEntity classEntity = env.fetchClass("ReflectionProperty");
        for (PropertyEntity e : this.entity.getStaticProperties()) {
            ReflectionProperty prop = new ReflectionProperty(env, classEntity);
            prop.setEntity(e);
            result.add(new ObjectMemory(prop));
        }
        return result.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getStaticPropertyValue(Environment env, Memory ... args) {
        String name = args[0].toString();
        PropertyEntity e = this.entity.findStaticProperty(name);
        if (e == null) {
            this.exception(env, Messages.ERR_UNDEFINED_PROPERTY.fetch(this.entity.getName(), name), new Object[0]);
            return Memory.NULL;
        }
        if (!e.isDefault()) {
            return Memory.FALSE;
        }
        return e.getDefaultValue(env).toImmutable();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", optional=@Reflection.Optional(value="NULL"))})
    public Memory getProperties(Environment env, Memory ... args) {
        ReflectionProperty prop;
        int mod = args[0].isNull() ? -1 : args[0].toInteger();
        ArrayMemory result = new ArrayMemory();
        ClassEntity classEntity = env.fetchClass("ReflectionProperty");
        if (mod == -1 || (mod & 1) == 1) {
            for (PropertyEntity e : this.entity.getStaticProperties()) {
                prop = new ReflectionProperty(env, classEntity);
                prop.setEntity(e);
                result.add(new ObjectMemory(prop));
            }
        }
        for (PropertyEntity e : this.entity.getProperties()) {
            if (!this.checkModifiers(e, mod)) continue;
            prop = new ReflectionProperty(env, classEntity);
            prop.setEntity(e);
            result.add(new ObjectMemory(prop));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getParentClass(Environment env, Memory ... args) {
        if (this.entity.getParent() == null) {
            return Memory.NULL;
        }
        ClassEntity classEntity = env.fetchClass("ReflectionClass");
        ReflectionClass result = new ReflectionClass(env, classEntity);
        result.setEntity(this.entity.getParent());
        return new ObjectMemory(result);
    }

    @Reflection.Signature
    public Memory getTraits(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (ClassEntity el : this.entity.getTraits().values()) {
            result.add(new ReflectionClass(env).setEntity(el));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getTraitNames(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (ClassEntity el : this.entity.getTraits().values()) {
            result.add(el.getName());
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getStartLine(Environment env, Memory ... args) {
        if (this.entity.isInternal() || this.entity.getTrace().isUnknown()) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(this.entity.getTrace().getStartLine() + 1);
    }

    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        if (this.entity.isInternal() || this.entity.getTrace().isUnknown()) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(this.entity.getTrace().getStartPosition() + 1);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory hasConstant(Environment env, Memory ... args) {
        return this.entity.findConstant(args[0].toString()) != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory hasMethod(Environment env, Memory ... args) {
        MethodEntity method = this.entity.findMethod(args[0].toString().toLowerCase());
        return method == null || method.isPrivate() && !method.getClazz().equals(this.entity) ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory hasProperty(Environment env, Memory ... args) {
        PropertyEntity prop = this.entity.findProperty(args[0].toString());
        return prop == null || prop.isPrivate() && !prop.getClazz().equals(this.entity) ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="interface")})
    public Memory implementsInterface(Environment env, Memory ... args) {
        String name = args[0].toString();
        ClassEntity e = env.fetchClass(name, true);
        if (!e.isInterface()) {
            this.exception(env, "Interface %s is a Class", name);
        }
        if (!this.entity.isInstanceOf(e)) {
            return Memory.FALSE;
        }
        return env.fetchClass(name).isInterface() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAbstract(Environment env, Memory ... args) {
        return this.entity.isAbstract() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isCloneable(Environment env, Memory ... args) {
        if (!this.entity.isClass()) {
            return Memory.FALSE;
        }
        if (this.entity.methodMagicClone == null || this.entity.methodMagicClone.isPublic()) {
            return Memory.TRUE;
        }
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isFinal(Environment env, Memory ... args) {
        return this.entity.isFinal() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object")})
    public Memory isInstance(Environment env, Memory ... args) {
        if (args[0].isObject()) {
            return args[0].toValue(ObjectMemory.class).getReflection().isInstanceOf(this.entity) ? Memory.TRUE : Memory.FALSE;
        }
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInstantiable(Environment env, Memory ... args) {
        if (this.entity.isClass() && !this.entity.isAbstract()) {
            return this.entity.methodConstruct == null || !this.entity.methodConstruct.isPrivate() ? Memory.TRUE : Memory.FALSE;
        }
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInterface(Environment env, Memory ... args) {
        return this.entity.isInterface() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isTrait(Environment env, Memory ... args) {
        return this.entity.isTrait() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInternal(Environment env, Memory ... args) {
        return this.entity.isInternal() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isIterable(Environment env, Memory ... args) {
        return this.entity.isInstanceOfLower("iterator") ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class")})
    public Memory isSubclassOf(Environment env, Memory ... args) {
        String name = args[0].toString().toLowerCase();
        return this.entity.isInstanceOf(name) && !this.entity.getLowerName().equals(name) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isUserDefined(Environment env, Memory ... args) {
        return this.entity.isInternal() ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature
    public Memory newInstance(Environment env, Memory ... args) throws Throwable {
        return new ObjectMemory((IObject)this.entity.newObject(env, env.trace(), true, args));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="args", type=HintType.ARRAY, optional=@Reflection.Optional(type=HintType.ARRAY))})
    public Memory newInstanceArgs(Environment env, Memory ... args) throws Throwable {
        if (args[0].isArray()) {
            return this.newInstance(env, args[0].toValue(ArrayMemory.class).values(true));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory newInstanceWithoutConstructor(Environment env, Memory ... args) throws Throwable {
        return new ObjectMemory((IObject)this.entity.newObject(env, env.trace(), false, args));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="reflector", type=HintType.OBJECT), @Reflection.Arg(value="return", type=HintType.BOOLEAN, optional=@Reflection.Optional(value="", type=HintType.BOOLEAN))})
    public static Memory export(Environment env, Memory ... args) {
        ReflectionClass e = new ReflectionClass(env, env.fetchClass("ReflectionClass"));
        if (args[1].toBoolean()) {
            return e.__toString(env, new Memory[0]);
        }
        env.echo(e.__toString(env, new Memory[0]));
        return Memory.NULL;
    }
}

