/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.util;

import java.util.NoSuchElementException;
import java.util.Scanner;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.ext.core.classes.util.WrapLocale;
import php.runtime.ext.core.classes.util.WrapRegex;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.lang.support.IComparableObject;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\util\\Scanner")
public class WrapScanner
extends BaseObject
implements IComparableObject<WrapScanner>,
Iterator {
    protected Scanner scanner;
    protected Memory current = null;
    protected Memory key = Memory.CONST_INT_M1;
    protected boolean valid = true;

    public WrapScanner(Environment env, Scanner scanner) {
        super(env);
        this.scanner = scanner;
    }

    public WrapScanner(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="source"), @Reflection.Arg(value="charset", optional=@Reflection.Optional(value="null"))})
    public Memory __construct(Environment env, Memory ... args) {
        this.scanner = args[0].instanceOf(Stream.class) ? (args[1].isNull() ? new Scanner(Stream.getInputStream(env, args[0])) : new Scanner(Stream.getInputStream(env, args[0]), args[1].toString())) : new Scanner(args[0].toString());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern", nativeType=WrapRegex.class, optional=@Reflection.Optional(value="null"))})
    public Memory hasNext(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            return this.scanner.hasNext() ? Memory.TRUE : Memory.FALSE;
        }
        return this.scanner.hasNext(args[0].toObject(WrapRegex.class).getMatcher().pattern()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getIOException(Environment env, Memory ... args) {
        if (this.scanner.ioException() == null) {
            return Memory.NULL;
        }
        return new ObjectMemory(new WrapIOException(env, (Throwable)this.scanner.ioException()));
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        return this.current;
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        return this.key;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="pattern", nativeType=WrapRegex.class, optional=@Reflection.Optional(value="null"))})
    public Memory next(Environment env, Memory ... args) {
        try {
            this.key = this.key.inc();
            this.current = StringMemory.valueOf(args.length == 0 || args[0].isNull() ? this.scanner.next() : this.scanner.next(args[0].toObject(WrapRegex.class).getMatcher().pattern()));
            return this.current;
        }
        catch (NoSuchElementException e) {
            this.valid = false;
            this.current = Memory.NULL;
            this.key = Memory.NULL;
            return Memory.NULL;
        }
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        if (this.current != null) {
            env.exception("Iterator of the scanner can be used only one time", new Object[0]);
        }
        this.valid = true;
        this.next(env, Memory.NULL);
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        return this.valid ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory nextLine(Environment env, Memory ... args) {
        try {
            return StringMemory.valueOf(this.scanner.nextLine());
        }
        catch (NoSuchElementException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory hasNextLine(Environment env, Memory ... args) {
        return this.scanner.hasNextLine() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="radix", optional=@Reflection.Optional(value="null"))})
    public Memory hasNextInt(Environment env, Memory ... args) {
        return (args[0].isNull() ? this.scanner.hasNextLong() : this.scanner.hasNextInt(args[0].toInteger())) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="radix", optional=@Reflection.Optional(value="null"))})
    public Memory nextInt(Environment env, Memory ... args) {
        try {
            return LongMemory.valueOf(args[0].isNull() ? this.scanner.nextLong() : this.scanner.nextLong(args[0].toInteger()));
        }
        catch (NoSuchElementException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory nextDouble(Environment env, Memory ... args) {
        try {
            return new DoubleMemory(this.scanner.nextDouble());
        }
        catch (NoSuchElementException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory hasNextDouble(Environment env, Memory ... args) {
        return this.scanner.hasNextDouble() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern", nativeType=WrapRegex.class)})
    public Memory useDelimiter(Environment env, Memory ... args) {
        this.scanner.useDelimiter(args[0].toObject(WrapRegex.class).getMatcher().pattern());
        return new ObjectMemory(this);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class)})
    public Memory useLocale(Environment env, Memory ... args) {
        this.scanner.useLocale(args[0].toObject(WrapLocale.class).getLocale());
        return new ObjectMemory(this);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public Memory useRadix(Environment env, Memory ... args) {
        this.scanner.useRadix(args[0].toInteger());
        return new ObjectMemory(this);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="regex", nativeType=WrapRegex.class)})
    public Memory skip(Environment env, Memory ... args) {
        try {
            this.scanner.skip(args[0].toObject(WrapRegex.class).getMatcher().pattern());
            return Memory.TRUE;
        }
        catch (NoSuchElementException e) {
            return Memory.FALSE;
        }
    }

    @Reflection.Signature
    public Memory reset(Environment env, Memory ... args) {
        this.scanner.reset();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __destruct(Environment env, Memory ... args) {
        this.scanner.close();
        return Memory.NULL;
    }

    @Override
    public boolean __equal(WrapScanner iObject) {
        return false;
    }

    @Override
    public boolean __identical(WrapScanner iObject) {
        return false;
    }

    @Override
    public boolean __greater(WrapScanner iObject) {
        return false;
    }

    @Override
    public boolean __greaterEq(WrapScanner iObject) {
        return false;
    }

    @Override
    public boolean __smaller(WrapScanner iObject) {
        return false;
    }

    @Override
    public boolean __smallerEq(WrapScanner iObject) {
        return false;
    }

    @Reflection.Signature
    private Memory __clone(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf(this).getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf(this).getNewIterator(env);
    }
}

