/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.lib;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Scanner;
import java.util.UUID;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.HintType;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.ext.core.MathFunctions;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ParameterEntity;

@Reflection.Name(value="php\\lib\\Str")
public class StrUtils
extends BaseObject {
    public StrUtils(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private Memory __construct(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="search"), @Reflection.Arg(value="fromIndex", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory pos(Environment env, Memory ... args) {
        int fromIndex = args[2].toInteger();
        return LongMemory.valueOf(args[0].toString().indexOf(args[1].toString(), fromIndex));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="search"), @Reflection.Arg(value="fromIndex", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory posIgnoreCase(Environment env, Memory ... args) {
        int fromIndex = args[2].toInteger();
        return LongMemory.valueOf(StringUtils.indexOfIgnoreCase(args[0].toString(), args[1].toBinaryString(), fromIndex));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="search"), @Reflection.Arg(value="fromIndex", optional=@Reflection.Optional(value="NULL"))})
    public static Memory lastPos(Environment env, Memory ... args) {
        return LongMemory.valueOf(args[2].isNull() ? args[0].toString().lastIndexOf(args[1].toString()) : args[0].toString().lastIndexOf(args[1].toString(), args[2].toInteger()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="search"), @Reflection.Arg(value="fromIndex", optional=@Reflection.Optional(value="NULL"))})
    public static Memory lastPosIgnoreCase(Environment env, Memory ... args) {
        String string = args[0].toString();
        int from = args[2].isNull() ? string.length() : args[2].toInteger();
        return LongMemory.valueOf(StringUtils.lastIndexOfIgnoreCase(string, args[1].toString(), from));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="beginIndex"), @Reflection.Arg(value="endIndex", optional=@Reflection.Optional(value="NULL"))})
    public static Memory sub(Environment env, Memory ... args) {
        int finish;
        String string = args[0].toString();
        int len = string.length();
        int begin = args[1].toInteger();
        if (args.length < 3 || args[2].isNull()) {
            finish = len;
        } else {
            finish = args[2].toInteger();
            if (finish > len) {
                return Memory.FALSE;
            }
        }
        if (begin > finish || begin < 0 || begin > len - 1) {
            return Memory.FALSE;
        }
        return StringMemory.valueOf(string.substring(begin, finish));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string1"), @Reflection.Arg(value="string2")})
    public static Memory compare(Environment env, Memory ... args) {
        return LongMemory.valueOf(args[0].toString().compareTo(args[1].toString()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string1"), @Reflection.Arg(value="string2")})
    public static Memory compareIgnoreCase(Environment env, Memory ... args) {
        return LongMemory.valueOf(args[0].toString().compareToIgnoreCase(args[1].toString()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string1"), @Reflection.Arg(value="string2")})
    public static Memory equalsIgnoreCase(Environment env, Memory ... args) {
        return TrueMemory.valueOf(args[0].toString().equalsIgnoreCase(args[1].toString()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="prefix"), @Reflection.Arg(value="offset", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory startsWith(Environment env, Memory ... args) {
        return args[0].toString().startsWith(args[1].toString(), args[2].toInteger()) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="suffix")})
    public static Memory endsWith(Environment env, Memory ... args) {
        return args[0].toString().endsWith(args[1].toString()) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory lower(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].toString().toLowerCase());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory upper(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].toString().toUpperCase());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory length(Environment env, Memory ... args) {
        return LongMemory.valueOf(args[0].toString().length());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="target"), @Reflection.Arg(value="replacement")})
    public static Memory replace(Environment env, Memory ... args) {
        String target = args[1].toString();
        String replacement = args[2].toString();
        if (target.length() == 1 && replacement.length() == 1) {
            return StringMemory.valueOf(args[0].toString().replace(target.charAt(0), replacement.charAt(0)));
        }
        return StringMemory.valueOf(args[0].toString().replace(target, replacement));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="amount")})
    public static Memory repeat(Environment env, Memory ... args) {
        String s = args[0].toString();
        int amount = args[1].toInteger();
        if (amount <= 0) {
            return Memory.FALSE;
        }
        if (s.length() == 1) {
            return new StringMemory(StringUtils.repeat(s.charAt(0), amount));
        }
        int cnt = args[1].toInteger();
        StringBuilder sb = new StringBuilder(cnt * s.length());
        for (int i = 0; i < cnt; ++i) {
            sb.append(s);
        }
        return new StringMemory(sb.toString());
    }

    protected static String trimStringByString(String text, String trimBy, boolean toLeft, boolean toRight) {
        int right;
        int left;
        int len = text.length();
        if (toLeft) {
            for (left = 0; left < len && trimBy.indexOf(text.charAt(left)) > -1; ++left) {
            }
        }
        if (toRight) {
            for (right = len - 1; right > 0 && trimBy.indexOf(text.charAt(right)) > -1; --right) {
            }
        }
        if (toLeft && toRight) {
            if (left == 0 && right == len - 1) {
                return text;
            }
            if (right == 0 && left > 0) {
                return text.substring(left);
            }
            return text.substring(left, right + 1);
        }
        if (toLeft) {
            if (left == len) {
                return "";
            }
            return text.substring(left);
        }
        if (toRight) {
            if (right == 0) {
                return "";
            }
            return text.substring(0, right + 1);
        }
        throw new IllegalArgumentException();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="charlist", optional=@Reflection.Optional(value=" \t\n\r\u0000\t"))})
    public static Memory trim(Environment env, Memory ... args) {
        String trimBy = args[1].toString();
        return StringMemory.valueOf(StrUtils.trimStringByString(args[0].toString(), trimBy, true, true));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="charlist", optional=@Reflection.Optional(value=" \t\n\r\u0000\t"))})
    public static Memory trimRight(Environment env, Memory ... args) {
        String trimBy = args[1].toString();
        return StringMemory.valueOf(StrUtils.trimStringByString(args[0].toString(), trimBy, false, true));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="charlist", optional=@Reflection.Optional(value=" \t\n\r\u0000\t"))})
    public static Memory trimLeft(Environment env, Memory ... args) {
        String trimBy = args[1].toString();
        return StringMemory.valueOf(StrUtils.trimStringByString(args[0].toString(), trimBy, true, false));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory reverse(Environment env, Memory ... args) {
        return new StringMemory(StringUtils.reverse(args[0].toString()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory shuffle(Environment env, Memory ... args) {
        char[] chars = args[0].toString().toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            int rand = MathFunctions.RANDOM.nextInt(length);
            char temp = chars[rand];
            chars[rand] = chars[i];
            chars[i] = temp;
        }
        return new StringMemory(new String(chars));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="separator"), @Reflection.Arg(value="limit", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory split(Environment env, Memory ... args) {
        String string = args[0].toString();
        if (string.isEmpty()) {
            return new ArrayMemory().toConstant();
        }
        String separator = args[1].toString();
        int limit = args[2].toInteger();
        String[] strings = StringUtils.split(string, separator, limit);
        return ArrayMemory.ofStrings(strings).toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection"), @Reflection.Arg(value="separator"), @Reflection.Arg(value="limit", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory join(Environment env, Memory ... args) {
        int length;
        String separator = args[1].toString();
        StringBuilder builder = new StringBuilder();
        int limit = args[2].toInteger();
        int i = 0;
        if (args[0].isArray()) {
            ArrayMemory array = args[0].toValue(ArrayMemory.class);
            int size = array.size();
            if (limit > 0 && limit < size) {
                size = limit;
            }
            for (Memory el : array) {
                builder.append(el);
                if (i != size - 1) {
                    builder.append(separator);
                }
                if (++i != size) continue;
                break;
            }
            return new StringMemory(builder.toString());
        }
        ParameterEntity.validateTypeHinting(env, 1, args, HintType.TRAVERSABLE, false);
        ForeachIterator iterator = args[0].getNewIterator(env);
        while (iterator.next()) {
            builder.append(iterator.getValue());
            builder.append(separator);
            if (limit <= 0 || ++i != limit) continue;
        }
        if ((length = builder.length()) <= 0) {
            return Memory.CONST_EMPTY_STRING;
        }
        builder.delete(length - separator.length(), length);
        return new StringMemory(builder.toString());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="charset")})
    public static Memory encode(Environment env, Memory ... args) {
        Charset charset;
        try {
            charset = Charset.forName(args[1].toString());
        }
        catch (Exception e) {
            return Memory.FALSE;
        }
        ByteBuffer buffer = charset.encode(args[0].toString());
        return new BinaryMemory(Arrays.copyOf(buffer.array(), buffer.limit()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="charset")})
    public static Memory decode(Environment env, Memory ... args) {
        Charset charset;
        try {
            charset = Charset.forName(args[1].toString());
        }
        catch (Exception e) {
            return Memory.FALSE;
        }
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(args[0].getBinaryBytes(env.getDefaultCharset())));
        return StringMemory.valueOf(charBuffer.toString());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="bigNumbers", optional=@Reflection.Optional(value="true"))})
    public static Memory isNumber(Environment env, Memory ... args) {
        return StringMemory.toLong(args[0].toString(), args[1].toBoolean()) != null ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="length", optional=@Reflection.Optional(value="16")), @Reflection.Arg(value="set", optional=@Reflection.Optional(value="qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0123456789"))})
    public static Memory random(Environment env, Memory ... args) {
        String set = args[1].toString();
        int resultLen = args[0].toInteger();
        int len = set.length();
        if (len < 1) {
            return Memory.FALSE;
        }
        StringBuilder sb = new StringBuilder(resultLen);
        for (int i = 0; i < resultLen; ++i) {
            sb.append(set.charAt(MathFunctions.RANDOM.nextInt(len)));
        }
        return StringMemory.valueOf(sb.toString());
    }

    protected static Memory _checkChars(Memory string, CharChecker checker) {
        String s = string.toString();
        int length = s.length();
        if (length == 0) {
            return Memory.FALSE;
        }
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (checker.check(ch)) continue;
            return Memory.FALSE;
        }
        return Memory.TRUE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory isLower(Environment env, Memory ... args) {
        String s = args[0].toString();
        int length = s.length();
        if (length == 0) {
            return Memory.FALSE;
        }
        boolean letterExists = false;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetter(ch)) continue;
            if (!Character.isLowerCase(ch)) {
                return Memory.FALSE;
            }
            letterExists = true;
        }
        return letterExists ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory isUpper(Environment env, Memory ... args) {
        String s = args[0].toString();
        int length = s.length();
        if (length == 0) {
            return Memory.FALSE;
        }
        boolean letterExists = false;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetter(ch)) continue;
            if (!Character.isUpperCase(ch)) {
                return Memory.FALSE;
            }
            letterExists = true;
        }
        return letterExists ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory upperFirst(Environment env, Memory ... args) {
        String s = args[0].toString();
        if (s.length() > 0) {
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return StringMemory.valueOf(s);
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory lowerFirst(Environment env, Memory ... args) {
        String s = args[0].toString();
        if (s.length() > 0) {
            s = Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
        return StringMemory.valueOf(s);
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="subString"), @Reflection.Arg(value="offset", optional=@Reflection.Optional(value="0"))})
    public static Memory count(Environment env, Memory ... args) {
        int count;
        block3: {
            int sLength;
            int length;
            String sub;
            String s;
            block2: {
                s = args[0].toString();
                sub = args[1].toString();
                int offset = args[2].toInteger();
                length = sub.length();
                count = 0;
                sLength = s.length();
                if (length != 1) break block2;
                char subChar = sub.charAt(0);
                for (int i = offset; i < sLength; ++i) {
                    if (s.charAt(i) != subChar) continue;
                    ++count;
                }
                break block3;
            }
            if (length <= 1) break block3;
            for (int i = offset; i < sLength; ++i) {
                if (!s.startsWith(sub, i)) continue;
                ++count;
                i += length;
            }
        }
        return LongMemory.valueOf(count);
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="search")})
    public static Memory contains(Environment env, Memory ... args) {
        String s = args[0].toString();
        return s.contains(args[1].toString()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory format(Environment env, Memory ... args) {
        String s = args[0].toString();
        Object[] _args = new Object[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            Memory arg;
            Comparable<Memory> _arg = arg = args[i];
            switch (arg.getRealType()) {
                case INT: {
                    _arg = arg.toLong();
                    break;
                }
                case DOUBLE: {
                    _arg = arg.toDouble();
                    break;
                }
                case BOOL: {
                    _arg = arg.toBoolean();
                }
            }
            _args[i - 1] = _arg;
        }
        return StringMemory.valueOf(String.format(s, _args));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value", optional=@Reflection.Optional(value="null"))})
    public static Memory uuid(Environment env, Memory ... args) {
        Memory value = args[0];
        String s = value.isNotNull() ? UUID.fromString(value.toString()).toString() : UUID.randomUUID().toString();
        return StringMemory.valueOf(s);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="algorithm", optional=@Reflection.Optional(value="SHA-1"))})
    public static Memory hash(Environment env, Memory ... args) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(args[1].toString());
        messageDigest.update(args[0].getBinaryBytes(env.getDefaultCharset()));
        return StringMemory.valueOf(String.format("%064x", new BigInteger(1, messageDigest.digest())));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="removeEmpty", optional=@Reflection.Optional(value="false"))})
    public static Memory lines(Environment env, Memory ... args) {
        boolean removeEmpty = args[1].toBoolean();
        Scanner scanner = new Scanner(args[0].toString());
        ArrayMemory result = new ArrayMemory();
        while (scanner.hasNextLine()) {
            String value = scanner.nextLine();
            if (removeEmpty && (value = value.trim()).isEmpty()) continue;
            result.add(value);
        }
        return result.toConstant();
    }

    protected static interface CharChecker {
        public boolean check(char var1);
    }
}

