/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.ext.core.MathConstants;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;

public class MathFunctions
extends FunctionsContainer {
    private static final MathConstants constants;
    public static Random MERSENNE_TWISTER;
    public static Random RANDOM;
    private static final double[] COS_CACHE;
    private static final double[] SIN_CACHE;
    private static final int MAX_COS_NEG;
    private static final int MAX_SIN_NEG;
    private static final int MAX_COS;
    private static final int MAX_SIN;

    @Override
    protected Map<String, Method> getNativeFunctions() {
        return new HashMap<String, Method>(){
            {
                this.put("acos", MathFunctions.this.getNative(Math.class, "acos", new Class[]{Double.TYPE}));
                this.put("asin", MathFunctions.this.getNative(Math.class, "asin", new Class[]{Double.TYPE}));
                this.put("atan2", MathFunctions.this.getNative(Math.class, "atan2", new Class[]{Double.TYPE, Double.TYPE}));
                this.put("atan", MathFunctions.this.getNative(Math.class, "atan", new Class[]{Double.TYPE}));
                this.put("ceil", MathFunctions.this.getNative(Math.class, "ceil", new Class[]{Double.TYPE}));
                this.put("cosh", MathFunctions.this.getNative(Math.class, "cosh", new Class[]{Double.TYPE}));
                this.put("sinh", MathFunctions.this.getNative(Math.class, "sinh", new Class[]{Double.TYPE}));
                this.put("tanh", MathFunctions.this.getNative(Math.class, "tanh", new Class[]{Double.TYPE}));
                this.put("tan", MathFunctions.this.getNative(Math.class, "tan", new Class[]{Double.TYPE}));
                this.put("rad2deg", MathFunctions.this.getNative(Math.class, "toDegrees", new Class[]{Double.TYPE}));
                this.put("deg2rad", MathFunctions.this.getNative(Math.class, "toRadians", new Class[]{Double.TYPE}));
                this.put("exp", MathFunctions.this.getNative(Math.class, "exp", new Class[]{Double.TYPE}));
                this.put("expm1", MathFunctions.this.getNative(Math.class, "expm1", new Class[]{Double.TYPE}));
                this.put("floor", MathFunctions.this.getNative(Math.class, "floor", new Class[]{Double.TYPE}));
                this.put("hypot", MathFunctions.this.getNative(Math.class, "hypot", new Class[]{Double.TYPE, Double.TYPE}));
                this.put("is_infinite", MathFunctions.this.getNative(Double.class, "isInfinite", new Class[]{Double.TYPE}));
                this.put("is_nan", MathFunctions.this.getNative(Double.class, "isNaN", new Class[]{Double.TYPE}));
                this.put("log10", MathFunctions.this.getNative(Math.class, "log10", new Class[]{Double.TYPE}));
                this.put("log1p", MathFunctions.this.getNative(Math.class, "log1p", new Class[]{Double.TYPE}));
                this.put("log", MathFunctions.this.getNative(Math.class, "log", new Class[]{Double.TYPE}));
                this.put("sqrt", MathFunctions.this.getNative(Math.class, "sqrt", new Class[]{Double.TYPE}));
            }
        };
    }

    private static double _cos(long value) {
        if (value >= (long)(-MAX_COS_NEG) && value < (long)MAX_COS) {
            return COS_CACHE[(int)value + MAX_COS_NEG];
        }
        return Math.cos(value);
    }

    private static double _sin(long value) {
        if (value >= (long)(-MAX_SIN_NEG) && value < (long)MAX_SIN) {
            return SIN_CACHE[(int)value + MAX_SIN_NEG];
        }
        return Math.sin(value);
    }

    @Runtime.Immutable
    public static double cos(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return Math.cos(memory.toDouble());
            }
            case STRING: {
                return MathFunctions.cos(memory.toNumeric());
            }
        }
        return MathFunctions._cos(memory.toLong());
    }

    @Runtime.Immutable
    public static double sin(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return Math.sin(memory.toDouble());
            }
            case STRING: {
                return MathFunctions.sin(memory.toNumeric());
            }
        }
        return MathFunctions._sin(memory.toLong());
    }

    @Runtime.Immutable
    public static Memory abs(Memory value) {
        switch (value.type) {
            case DOUBLE: {
                return new DoubleMemory(Math.abs(value.toDouble()));
            }
            case STRING: {
                return MathFunctions.abs(value.toNumeric());
            }
        }
        return LongMemory.valueOf(Math.abs(value.toLong()));
    }

    @Runtime.Immutable
    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    @Runtime.Immutable
    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    @Runtime.Immutable
    public static double atanh(double x) {
        return 0.5 * Math.log((x + 1.0) / (x - 1.0));
    }

    @Runtime.Immutable
    public static String base_convert(String number, int fromBase, int toBase) {
        return new BigInteger(number, fromBase).toString(toBase);
    }

    @Runtime.Immutable
    public static long bindec(String binary) {
        try {
            return Long.parseLong(binary, 2);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Runtime.Immutable
    public static String decbin(long value) {
        return Long.toString(value, 2);
    }

    @Runtime.Immutable
    public static String dechex(long value) {
        return Long.toString(value, 16);
    }

    @Runtime.Immutable
    public static String decoct(long value) {
        return Long.toString(value, 8);
    }

    @Runtime.Immutable
    public static double fmod(double x, double y) {
        return x % y;
    }

    @Runtime.Immutable
    public static long getmaxrand() {
        return Integer.MAX_VALUE;
    }

    @Runtime.Immutable
    public static long hexdec(String hex) {
        try {
            return Long.parseLong(hex, 16);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Runtime.Immutable
    public static boolean is_finite(double value) {
        return !Double.isInfinite(value);
    }

    public static double lcg_value() {
        return Math.random();
    }

    @Runtime.Immutable
    public static Memory max(Memory value, Memory ... args) {
        if (value.isArray() && args == null) {
            Memory max = null;
            for (Memory one : (ArrayMemory)value) {
                if (max != null && !one.greater(max)) continue;
                max = one;
            }
            return max == null ? Memory.NULL : max.toImmutable();
        }
        Memory max = value;
        if (args != null) {
            for (Memory one : args) {
                if (!one.greater(max)) continue;
                max = one;
            }
        }
        return max.toImmutable();
    }

    @Runtime.Immutable
    public static Memory min(Memory value, Memory ... args) {
        if (value.isArray() && args == null) {
            Memory min = null;
            for (Memory one : (ArrayMemory)value) {
                if (min != null && !one.smaller(min)) continue;
                min = one;
            }
            return min == null ? Memory.NULL : min.toImmutable();
        }
        Memory min = value;
        for (Memory one : args) {
            if (!one.smaller(min)) continue;
            min = one;
        }
        return min.toImmutable();
    }

    @Runtime.Immutable
    public static long mt_getrandmax() {
        return Integer.MAX_VALUE;
    }

    public static long mt_rand() {
        return MERSENNE_TWISTER.nextLong();
    }

    public static Memory mt_rand(long min, long max) {
        if (max < min) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf((long)MERSENNE_TWISTER.nextInt((int)(max - min) + 1) + min);
    }

    public static void mt_srand() {
        MERSENNE_TWISTER = new Random();
    }

    public static void mt_srand(long seed) {
        MERSENNE_TWISTER = new Random(seed);
    }

    public static long rand() {
        return RANDOM.nextLong();
    }

    public static Memory rand(long min, long max) {
        if (max < min) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf((long)RANDOM.nextInt((int)(max - min) + 1) + min);
    }

    public static void srand() {
        RANDOM = new Random();
    }

    public static void srand(long seed) {
        RANDOM = new Random(seed);
    }

    @Runtime.Immutable
    public static Memory octdec(String octalString) {
        try {
            return LongMemory.valueOf(Long.parseLong(octalString, 8));
        }
        catch (NumberFormatException e) {
            return Memory.FALSE;
        }
    }

    @Runtime.Immutable
    public static double pi() {
        return MathFunctions.constants.M_PI;
    }

    @Runtime.Immutable
    public static Memory pow(Memory base, Memory exp) {
        Memory realBase = base.toNumeric();
        Memory realExp = exp.toNumeric();
        if (realBase.type == Memory.Type.INT && realExp.type == Memory.Type.INT) {
            double result = Math.pow(realBase.toLong(), realExp.toLong());
            if (result > 9.223372036854776E18) {
                return DoubleMemory.valueOf(result);
            }
            return LongMemory.valueOf((long)result);
        }
        return new DoubleMemory(Math.pow(base.toDouble(), exp.toDouble()));
    }

    @Runtime.Immutable
    public static double round(double value) {
        return Math.round(value);
    }

    @Runtime.Immutable
    public static double round(double value, int precession) {
        return BigDecimal.valueOf(value).setScale(precession, RoundingMode.HALF_UP).doubleValue();
    }

    @Runtime.Immutable
    public static double round(double value, int precession, int mode) {
        MathContext context;
        switch (mode) {
            case 2: {
                context = new MathContext(precession, RoundingMode.DOWN);
                break;
            }
            case 3: {
                context = new MathContext(precession, RoundingMode.HALF_EVEN);
                break;
            }
            case 4: {
                if ((long)value % 2L == 0L) {
                    context = new MathContext(precession, RoundingMode.UP);
                    break;
                }
                context = new MathContext(precession, RoundingMode.DOWN);
                break;
            }
            default: {
                context = new MathContext(precession, RoundingMode.UP);
            }
        }
        return BigDecimal.valueOf(value).round(context).doubleValue();
    }

    static {
        int i;
        constants = new MathConstants();
        MERSENNE_TWISTER = new Random();
        RANDOM = new Random();
        COS_CACHE = new double[127];
        SIN_CACHE = new double[127];
        MAX_COS_NEG = COS_CACHE.length;
        MAX_SIN_NEG = SIN_CACHE.length;
        MAX_COS = COS_CACHE.length - MAX_COS_NEG;
        MAX_SIN = SIN_CACHE.length - MAX_SIN_NEG;
        for (i = -MAX_COS_NEG; i < MAX_COS; ++i) {
            MathFunctions.COS_CACHE[i + MathFunctions.MAX_COS_NEG] = Math.cos(i);
        }
        for (i = -MAX_SIN_NEG; i < MAX_SIN; ++i) {
            MathFunctions.SIN_CACHE[i + MathFunctions.MAX_SIN_NEG] = Math.cos(i);
        }
    }
}

