/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core;

import java.util.HashSet;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.Countable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;

public class ArrayFunctions
extends FunctionsContainer {
    private static int recursive_count(Environment env, TraceInfo trace, ArrayMemory array, Set<Integer> used) {
        ForeachIterator iterator = array.foreachIterator(false, false);
        int size = array.size();
        while (iterator.next()) {
            int pointer;
            Memory el = iterator.getValue();
            if (!el.isArray()) continue;
            if (used == null) {
                used = new HashSet<Integer>();
            }
            if (!used.add(pointer = el.getPointer())) {
                env.warning(trace, "recursion detected", new Object[0]);
            } else {
                size += ArrayFunctions.recursive_count(env, trace, array, used);
            }
            used.remove(pointer);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Runtime.Immutable
    public static Memory count(Environment env, TraceInfo trace, Memory var, int mode) {
        switch (var.type) {
            case ARRAY: {
                if (mode == 1) {
                    return LongMemory.valueOf(ArrayFunctions.recursive_count(env, trace, var.toValue(ArrayMemory.class), null));
                }
                return LongMemory.valueOf(var.toValue(ArrayMemory.class).size());
            }
            case NULL: {
                return Memory.CONST_INT_0;
            }
            case OBJECT: {
                ObjectMemory objectMemory = var.toValue(ObjectMemory.class);
                if (objectMemory.value instanceof Countable) {
                    env.pushCall(objectMemory.value, "count", new Memory[0]);
                    try {
                        long size = ((Countable)objectMemory.value).count(env, new Memory[0]).toLong();
                        Memory memory = LongMemory.valueOf(size);
                        return memory;
                    }
                    finally {
                        env.popCall();
                    }
                }
                return Memory.CONST_INT_1;
            }
        }
        return Memory.CONST_INT_1;
    }

    @Runtime.Immutable
    public static Memory count(Environment env, TraceInfo trace, Memory var) {
        return ArrayFunctions.count(env, trace, var, 0);
    }

    @Runtime.Immutable
    public static Memory sizeof(Environment env, TraceInfo trace, Memory var) {
        return ArrayFunctions.count(env, trace, var, 0);
    }

    @Runtime.Immutable
    public static Memory sizeof(Environment env, TraceInfo trace, Memory var, int mode) {
        return ArrayFunctions.count(env, trace, var, mode);
    }
}

