/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.develnext.jphp.zend.ext.standard.StringConstants;
import org.develnext.jphp.zend.ext.support.NaturalOrderComparator;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.common.DigestUtils;
import php.runtime.common.Messages;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.TodoException;
import php.runtime.ext.core.MathFunctions;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringBuilderMemory;
import php.runtime.memory.StringMemory;
import php.runtime.util.PrintF;
import php.runtime.util.SScanF;

public class StringFunctions
extends FunctionsContainer {
    private static final DecimalFormatSymbols DEFAULT_DECIMAL_FORMAT_SYMBOLS;
    private static final StringConstants constants;
    private static final ArrayMemory HTML_ENTITIES;
    private static final ArrayMemory HTML_SPECIALCHARS;
    private static final char[] SOUNDEX_VALUES;
    private static final ThreadLocal<MessageDigest> md5Digest;
    private static final ThreadLocal<MessageDigest> sha1Digest;

    protected static char toUUChar(int d) {
        if (d == 0) {
            return '`';
        }
        return (char)(32 + (d & 0x3F));
    }

    protected static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected static char toUpperCase(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(65 + (ch - 97));
        }
        return ch;
    }

    protected static char toHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 97);
    }

    protected static char toUpperHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 65);
    }

    protected static int hexToDigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        return -1;
    }

    protected static int octToDigit(char ch) {
        if ('0' <= ch && ch <= '7') {
            return ch - 48;
        }
        return -1;
    }

    public static Memory sscanf(Environment env, TraceInfo trace, String string, String format, Memory ... args) {
        SScanF.Segment[] formatArray = SScanF.parse(env, trace, format);
        int strlen = string.length();
        int sIndex = 0;
        boolean isReturnArray = args == null || args.length == 0;
        int argIndex = 0;
        if (strlen == 0) {
            return isReturnArray ? Memory.NULL : Memory.CONST_INT_M1;
        }
        ArrayMemory array = new ArrayMemory();
        for (int i = 0; i < formatArray.length; ++i) {
            Memory var;
            SScanF.Segment segment = formatArray[i];
            if (!segment.isAssigned()) {
                var = null;
            } else if (isReturnArray) {
                var = array;
            } else if (argIndex < args.length) {
                var = args[argIndex];
                if (sIndex < strlen) {
                    ++argIndex;
                }
            } else {
                env.warning(trace, "sscanf(): not enough variables passed in", new Object[0]);
                var = new ReferenceMemory();
            }
            if (!(var instanceof ReferenceMemory)) {
                var = new ReferenceMemory(var);
            }
            if ((sIndex = segment.apply(string, strlen, sIndex, (ReferenceMemory)var, isReturnArray)) >= 0) continue;
            if (isReturnArray) {
                return StringFunctions.sscanfFillNull(array, formatArray, i);
            }
            return LongMemory.valueOf(argIndex);
        }
        return StringFunctions.sscanfReturn(env, trace, array, args, argIndex, isReturnArray, false);
    }

    private static Memory sscanfReturn(Environment env, TraceInfo trace, ArrayMemory array, Memory[] args, int argIndex, boolean isReturnArray, boolean isWarn) {
        if (isReturnArray) {
            return array;
        }
        if (isWarn && args != null && argIndex != args.length) {
            env.warning(trace, "%s vars passed in but saw only %s '%' args", args.length, argIndex);
        }
        return LongMemory.valueOf(argIndex);
    }

    private static Memory sscanfFillNull(ArrayMemory array, SScanF.Segment[] formatArray, int fIndex) {
        while (fIndex < formatArray.length) {
            SScanF.Segment segment = formatArray[fIndex];
            if (segment.isAssigned()) {
                array.add(Memory.NULL);
            }
            ++fIndex;
        }
        return array;
    }

    public static Memory sprintf(Environment env, TraceInfo trace, String format, Memory ... args) {
        PrintF printF = new PrintF(env.getLocale(), format, args);
        String result = printF.toString();
        if (result == null) {
            env.warning(trace, "Too few arguments", new Object[0]);
            return Memory.NULL;
        }
        return new StringMemory(result);
    }

    public static Memory vsprintf(Environment env, TraceInfo trace, String format, Memory array) {
        if (array.isArray()) {
            return StringFunctions.sprintf(env, trace, format, array.toValue(ArrayMemory.class).values());
        }
        return StringFunctions.sprintf(env, trace, format, array);
    }

    public static int printf(Environment env, TraceInfo trace, String format, Memory ... args) {
        Memory str = StringFunctions.sprintf(env, trace, format, args);
        if (str.isNull()) {
            return 0;
        }
        String value = str.toString();
        env.echo(value);
        return value.length();
    }

    public static int vprintf(Environment env, TraceInfo trace, String format, Memory array) {
        if (array.isArray()) {
            return StringFunctions.printf(env, trace, format, array.toValue(ArrayMemory.class).values());
        }
        return StringFunctions.printf(env, trace, format, array);
    }

    private static boolean[] parseCharsetBitmap(Environment env, TraceInfo trace, String charset) {
        boolean[] bitmap = new boolean[256];
        int length = charset.length();
        for (int i = 0; i < length; ++i) {
            char ch = charset.charAt(i);
            if (ch >= '\u0100') continue;
            bitmap[ch] = true;
            if (length <= i + 3 || charset.charAt(i + 1) != '.' || charset.charAt(i + 2) != '.') continue;
            char last = charset.charAt(i + 3);
            if (last < ch) {
                env.warning(trace, "character set range is invalid: %s..%s", Character.valueOf(ch), Character.valueOf(last));
                continue;
            }
            i += 3;
            while (ch <= last) {
                bitmap[ch] = true;
                ch = (char)(ch + '\u0001');
            }
        }
        return bitmap;
    }

    @Runtime.Immutable
    public static String addcslashes(Environment env, TraceInfo trace, String source, String characters) {
        boolean[] bitmap = StringFunctions.parseCharsetBitmap(env, trace, characters);
        int length = source.length();
        StringBuilder sb = new StringBuilder(length * 5 / 4);
        block9: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch >= '\u0100' || !bitmap[ch]) {
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case '\u0007': {
                    sb.append("\\a");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\u000b': {
                    sb.append("\\v");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch >= '\u007f') {
                        sb.append("\\");
                        sb.append((char)(48 + (ch >> 6 & 7)));
                        sb.append((char)(48 + (ch >> 3 & 7)));
                        sb.append((char)(48 + (ch & 7)));
                        continue block9;
                    }
                    sb.append("\\");
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String addslashes(String source) {
        StringBuilder sb = new StringBuilder();
        int length = source.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block6;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String bin2hex(Memory _value) {
        String value = _value.toBinaryString();
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            int d = ch >> 4 & 0xF;
            if (d < 10) {
                sb.append((char)(d + 48));
            } else {
                sb.append((char)(d + 97 - 10));
            }
            d = ch & 0xF;
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d + 97 - 10));
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String hex2bin(Memory _s) {
        String s = _s.toBinaryString();
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i + 1 < len) {
            int d1 = StringFunctions.hexDigit(s.charAt(i));
            int d2 = StringFunctions.hexDigit(s.charAt(i + 1));
            int d = d1 * 16 + d2;
            sb.append((char)d);
            i += 2;
        }
        return sb.toString();
    }

    private static int hexDigit(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        return 0;
    }

    @Runtime.Immutable
    public static Memory chunk_split(Environment env, TraceInfo trace, String body, int chunkLen, String end) {
        if (chunkLen < 1) {
            env.warning(trace, "chunk_split(): Chunk length should be greater than zero", new Object[0]);
            return Memory.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i + chunkLen <= body.length()) {
            sb.append(body.substring(i, i + chunkLen));
            sb.append(end);
            i += chunkLen;
        }
        if (i < body.length()) {
            sb.append(body.substring(i));
            sb.append(end);
        }
        return new StringMemory(sb.toString());
    }

    @Runtime.Immutable
    public static Memory chunk_split(Environment env, TraceInfo trace, String body, int chunkLen) {
        return StringFunctions.chunk_split(env, trace, body, chunkLen, "\r\n");
    }

    @Runtime.Immutable
    public static Memory chunk_split(Environment env, TraceInfo trace, String body) {
        return StringFunctions.chunk_split(env, trace, body, 76);
    }

    @Runtime.Immutable
    public static Memory convert_cyr_string(Environment env, TraceInfo trace, String str, String from, String to) {
        throw new TodoException();
    }

    @Runtime.Immutable
    public static String trim(String s) {
        return s.trim();
    }

    @Runtime.Immutable
    public static String trim(String s, String charsetList) {
        return StringFunctions.rtrim(StringFunctions.ltrim(s, charsetList), charsetList);
    }

    @Runtime.Immutable
    public static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return i >= s.length() ? "" : s.substring(i);
    }

    @Runtime.Immutable
    public static String ltrim(String s, String charsetList) {
        int i;
        for (i = 0; i < s.length() && charsetList.indexOf(s.charAt(i)) > -1; ++i) {
        }
        return i >= s.length() ? "" : s.substring(i);
    }

    @Runtime.Immutable
    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i > 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return i <= 0 ? "" : s.substring(0, i + 1);
    }

    @Runtime.Immutable
    public static String rtrim(String s, String charsetList) {
        int i;
        for (i = s.length() - 1; i > 0 && charsetList.indexOf(s.charAt(i)) > -1; --i) {
        }
        return i <= 0 ? "" : s.substring(0, i + 1);
    }

    @Runtime.Immutable
    public static String chop(String s) {
        return StringFunctions.rtrim(s);
    }

    @Runtime.Immutable
    public static String quotemeta(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len * 5 / 4);
        block3: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static Memory soundex(String string) {
        int length = string.length();
        if (length == 0) {
            return Memory.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        char lastCode = '\u0000';
        for (int i = 0; i < length && count < 4; ++i) {
            char ch = StringFunctions.toUpperCase(string.charAt(i));
            if ('A' > ch || ch > 'Z') continue;
            char code = SOUNDEX_VALUES[ch - 65];
            if (count == 0) {
                sb.append(ch);
                ++count;
            } else if (code != '0' && code != lastCode) {
                sb.append(code);
                ++count;
            }
            lastCode = code;
        }
        while (count < 4) {
            sb.append('0');
            ++count;
        }
        return new StringMemory(sb.toString());
    }

    @Runtime.Immutable
    public static String str_rot13(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int off;
            char ch = string.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                off = ch - 97;
                sb.append((char)(97 + (off + 13) % 26));
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                off = ch - 65;
                sb.append((char)(65 + (off + 13) % 26));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String str_shuffle(String string) {
        char[] chars = string.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            int rand = MathFunctions.RANDOM.nextInt(length);
            char temp = chars[rand];
            chars[rand] = chars[i];
            chars[i] = temp;
        }
        return new String(chars);
    }

    public static Memory str_split(String string, int chunk) {
        ArrayMemory array = new ArrayMemory();
        if (string.isEmpty()) {
            array.add(new StringMemory(string));
            return array;
        }
        int strLen = string.length();
        for (int i = 0; i < strLen; i += chunk) {
            String value = i + chunk <= strLen ? string.substring(i, i + chunk) : string.substring(i);
            array.add(new StringMemory(value));
        }
        return array;
    }

    public static Memory str_split(String string) {
        return StringFunctions.str_split(string, 1);
    }

    @Runtime.Immutable
    public static int strcoll(String value1, String value2) {
        int cmp = value1.compareTo(value2);
        if (cmp == 0) {
            return 0;
        }
        if (cmp < 0) {
            return -1;
        }
        return 1;
    }

    @Runtime.Immutable
    public static int strcmp(String value1, String value2) {
        int aLen = value1.length();
        int bLen = value2.length();
        for (int i = 0; i < aLen && i < bLen; ++i) {
            char chB;
            char chA = value1.charAt(i);
            if (chA == (chB = value2.charAt(i))) continue;
            if (chA < chB) {
                return -1;
            }
            return 1;
        }
        if (aLen == bLen) {
            return 0;
        }
        if (aLen < bLen) {
            return -1;
        }
        return 1;
    }

    @Runtime.Immutable
    public static int strncmp(String value1, String value2, int len) {
        int len1 = value1.length();
        int len2 = value2.length();
        String _value1 = len1 <= len ? value1 : value1.substring(0, len);
        String _value2 = len2 <= len ? value2 : value2.substring(0, len);
        return _value1.compareTo(_value2);
    }

    @Runtime.Immutable
    public static int strcasecmp(String value1, String value2) {
        return value1.compareToIgnoreCase(value2);
    }

    @Runtime.Immutable
    public static int strncasecmp(String value1, String value2, int len) {
        int len1 = value1.length();
        int len2 = value2.length();
        String _value1 = len1 <= len ? value1 : value1.substring(0, len);
        String _value2 = len2 <= len ? value2 : value2.substring(0, len);
        return _value1.compareToIgnoreCase(_value2);
    }

    @Runtime.Immutable
    public static String nl2br(String value) {
        return StringFunctions.nl2br(value, true);
    }

    @Runtime.Immutable
    public static Memory implode(Environment env, TraceInfo trace, Memory glue, Memory pieces) {
        String delimiter;
        ArrayMemory array;
        if (glue.isArray()) {
            array = (ArrayMemory)glue;
            delimiter = pieces.toString();
        } else if (pieces.isArray()) {
            array = (ArrayMemory)pieces;
            delimiter = glue.toString();
        } else {
            env.warning(trace, "Argument must be an array", new Object[0]);
            return Memory.NULL;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int size = array.size();
        for (Memory el : array) {
            builder.append(el.toString());
            if (i != size - 1) {
                builder.append(delimiter);
            }
            ++i;
        }
        return new StringMemory(builder.toString());
    }

    @Runtime.Immutable
    public static Memory implode(Environment env, TraceInfo trace, Memory pieces) {
        return StringFunctions.implode(env, trace, Memory.NULL, pieces);
    }

    @Runtime.Immutable
    public static Memory join(Environment env, TraceInfo trace, Memory glue, Memory pieces) {
        return StringFunctions.implode(env, trace, glue, pieces);
    }

    @Runtime.Immutable
    public static Memory join(Environment env, TraceInfo trace, Memory pieces) {
        return StringFunctions.implode(env, trace, Memory.NULL, pieces);
    }

    public static Memory explode(String delimiter, String string, int limit) {
        String[] result;
        if (limit == 0) {
            limit = 1;
        }
        if (limit < 0) {
            result = StringUtils.split(string, delimiter);
            result = Arrays.copyOfRange(result, 0, result.length + limit);
        } else {
            result = StringUtils.split(string, delimiter, limit);
        }
        return ArrayMemory.ofStrings(result);
    }

    public static Memory explode(String delimiter, String string) {
        return StringFunctions.explode(delimiter, string, Integer.MAX_VALUE);
    }

    @Runtime.Immutable
    public static String lcfirst(String value) {
        if (value.isEmpty()) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(value.charAt(0))) + value.substring(1);
    }

    @Runtime.Immutable
    public static String ucfirst(String value) {
        if (value.isEmpty()) {
            return "";
        }
        return String.valueOf(Character.toUpperCase(value.charAt(0))) + value.substring(1);
    }

    @Runtime.Immutable
    public static String ucwords(String value) {
        char[] buffer = value.toCharArray();
        boolean prevSpace = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isSpaceChar(ch)) {
                prevSpace = true;
                continue;
            }
            if (!prevSpace) continue;
            buffer[i] = Character.toUpperCase(ch);
            prevSpace = false;
        }
        return new String(buffer);
    }

    public static Memory md5(Environment env, Memory value, boolean rawOutput) {
        MessageDigest md = md5Digest.get();
        md.reset();
        md.update(value.getBinaryBytes(env.getDefaultCharset()));
        if (rawOutput) {
            return new BinaryMemory(md.digest());
        }
        return new StringMemory(DigestUtils.bytesToHex(md.digest()));
    }

    public static Memory md5(Environment env, Memory value) {
        return StringFunctions.md5(env, value, false);
    }

    public static Memory md5_file(Environment env, TraceInfo trace, String fileName) {
        return StringFunctions.md5_file(env, trace, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Memory md5_file(Environment env, TraceInfo trace, String fileName, boolean rawOutput) {
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fileName));){
            int len;
            MessageDigest md = md5Digest.get();
            md.reset();
            byte[] buff = new byte[1024];
            while ((len = reader.read(buff)) > 0) {
                md.update(buff, 0, len);
            }
            if (rawOutput) {
                BinaryMemory binaryMemory = new BinaryMemory(md.digest());
                return binaryMemory;
            }
            StringMemory stringMemory = new StringMemory(DigestUtils.bytesToHex(md.digest()));
            return stringMemory;
        }
        catch (FileNotFoundException e) {
            env.warning(trace, "md5_file(): " + Messages.ERR_FILE_NOT_FOUND.fetch(fileName), new Object[0]);
            return Memory.FALSE;
        }
        catch (IOException e) {
            env.warning(trace, "md5_file(): " + e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    public static Memory sha1(Environment env, Memory value, boolean rawOutput) {
        MessageDigest md = sha1Digest.get();
        md.reset();
        md.update(value.getBinaryBytes(env.getDefaultCharset()));
        if (rawOutput) {
            return new BinaryMemory(md.digest());
        }
        return new StringMemory(DigestUtils.bytesToHex(md.digest()));
    }

    @Runtime.Immutable
    public static Memory sha1(Environment env, Memory value) {
        return StringFunctions.sha1(env, value, false);
    }

    public static Memory sha1_file(Environment env, TraceInfo trace, String fileName) {
        return StringFunctions.sha1_file(env, trace, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Memory sha1_file(Environment env, TraceInfo trace, String fileName, boolean rawOutput) {
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fileName));){
            int len;
            MessageDigest md = sha1Digest.get();
            md.reset();
            byte[] buff = new byte[1024];
            while ((len = reader.read(buff)) > 0) {
                md.update(buff, 0, len);
            }
            if (rawOutput) {
                BinaryMemory binaryMemory = new BinaryMemory(md.digest());
                return binaryMemory;
            }
            StringMemory stringMemory = new StringMemory(DigestUtils.bytesToHex(md.digest()));
            return stringMemory;
        }
        catch (FileNotFoundException e) {
            env.warning(trace, "sha1_file(): " + Messages.ERR_FILE_NOT_FOUND.fetch(fileName), new Object[0]);
            return Memory.FALSE;
        }
        catch (IOException e) {
            env.warning(trace, "sha1_file(): " + e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    @Runtime.Immutable
    public static Memory substr(String value, int start, int length) {
        int end;
        int strLen = value.length();
        if (start < 0) {
            start = strLen + start;
        }
        if (start < 0 || start >= strLen) {
            return Memory.FALSE;
        }
        if (length == 0) {
            return Memory.CONST_EMPTY_STRING;
        }
        if (length < 0) {
            end = strLen + length;
        } else {
            int n = end = strLen < length ? strLen : start + length;
        }
        if (end <= start) {
            return Memory.FALSE;
        }
        if (strLen <= end) {
            return new StringMemory(value.substring(start));
        }
        return new StringMemory(value.substring(start, end));
    }

    @Runtime.Immutable
    public static Memory substr(String value, int start) {
        int length = value.length();
        if (start < 0) {
            start = length + start;
        }
        if (start < 0 || start > length) {
            return Memory.FALSE;
        }
        return new StringMemory(value.substring(start));
    }

    @Runtime.Immutable
    public static Memory substr_count(Environment env, TraceInfo trace, String haystack, String needle, int offset, Memory _length) {
        int end;
        if (needle.isEmpty()) {
            env.warning(trace, "Empty substring", new Object[0]);
            return Memory.FALSE;
        }
        int haystackLength = haystack.length();
        if (offset < 0) {
            env.warning(trace, "Offset should be greater than or equal to 0", new Object[0]);
            return Memory.FALSE;
        }
        if (offset > haystackLength) {
            env.warning(trace, "Offset value %s exceeds string length", offset);
            return Memory.FALSE;
        }
        int needleLength = needle.length();
        if (_length != null) {
            int length = _length.toInteger();
            end = offset + length - 1;
            if (length <= 0) {
                env.warning(trace, "Length should be greater than 0", new Object[0]);
                return Memory.FALSE;
            }
            if (length > haystackLength - offset) {
                env.warning(trace, "Length value %s exceeds string length", length);
                return Memory.FALSE;
            }
        } else {
            end = haystackLength - needleLength + 1;
        }
        int count = 0;
        if (needleLength == 1) {
            char ch = needle.charAt(0);
            for (int i = offset; i < end; ++i) {
                if (ch != haystack.charAt(i)) continue;
                ++count;
            }
        } else {
            for (int i = offset; i < end; ++i) {
                if (!haystack.startsWith(needle, i)) continue;
                ++count;
                i += needleLength;
            }
        }
        return LongMemory.valueOf(count);
    }

    @Runtime.Immutable
    public static Memory substr_count(Environment env, TraceInfo trace, String haystack, String needle, int offset) {
        return StringFunctions.substr_count(env, trace, haystack, needle, offset, null);
    }

    @Runtime.Immutable
    public static Memory substr_count(Environment env, TraceInfo trace, String haystack, String needle) {
        return StringFunctions.substr_count(env, trace, haystack, needle, 0, null);
    }

    @Runtime.Immutable
    public static Memory substr_compare(Environment env, TraceInfo trace, String mainStr, String str, int offset, Memory lenV, boolean isCaseInsensitive) {
        int len;
        int strLen = mainStr.length();
        if (lenV != null && lenV.toInteger() == 0) {
            return Memory.FALSE;
        }
        int n = len = lenV == null ? 0 : lenV.toInteger();
        if (strLen < offset) {
            env.warning(trace, "offset can not be greater than length of string", new Object[0]);
            return Memory.FALSE;
        }
        if (len > strLen || len + offset > strLen) {
            return Memory.FALSE;
        }
        mainStr = lenV == null ? StringFunctions.substr(mainStr, offset).toString() : StringFunctions.substr(mainStr, offset, len).toString();
        String string = str = lenV == null ? str : StringFunctions.substr(str, 0, len).toString();
        if (isCaseInsensitive) {
            return LongMemory.valueOf(StringFunctions.strcasecmp(mainStr, str));
        }
        return LongMemory.valueOf(StringFunctions.strcmp(mainStr, str));
    }

    @Runtime.Immutable
    public static Memory substr_compare(Environment env, TraceInfo trace, String mainStr, String str, int offset, Memory lenV) {
        return StringFunctions.substr_compare(env, trace, mainStr, str, offset, lenV, false);
    }

    @Runtime.Immutable
    public static Memory substr_compare(Environment env, TraceInfo trace, String mainStr, String str, int offset) {
        return StringFunctions.substr_compare(env, trace, mainStr, str, offset, null, false);
    }

    @Runtime.Immutable
    public static String strtolower(String string) {
        return string.toLowerCase();
    }

    @Runtime.Immutable
    public static String strtoupper(String string) {
        return string.toUpperCase();
    }

    @Runtime.Immutable
    public static String strrev(String string) {
        return StringUtils.reverse(string);
    }

    @Runtime.Immutable
    public static Memory strrchr(String haystack, char needle) {
        int i = haystack.lastIndexOf(needle);
        if (i > 0) {
            return new StringMemory(haystack.substring(i));
        }
        return Memory.FALSE;
    }

    @Runtime.Immutable
    public static Memory strchr(String haystack, char needle, boolean beforeNeedle) {
        int i = haystack.indexOf(needle);
        if (i >= 0) {
            return new StringMemory(beforeNeedle ? haystack.substring(0, i) : haystack.substring(i));
        }
        return Memory.FALSE;
    }

    @Runtime.Immutable
    public static Memory strchr(String haystack, char needle) {
        return StringFunctions.strchr(haystack, needle, false);
    }

    @Runtime.Immutable
    public static Memory strstr(String haystack, char needle, boolean beforeNeedle) {
        return StringFunctions.strchr(haystack, needle, beforeNeedle);
    }

    @Runtime.Immutable
    public static Memory strstr(String haystack, char needle) {
        return StringFunctions.strchr(haystack, needle, false);
    }

    @Runtime.Immutable
    public static Memory strpos(Environment env, TraceInfo trace, String haystack, Memory needle, int offset) {
        int p;
        int haystackLen = haystack.length();
        if (offset < 0 || offset > haystackLen) {
            env.warning(trace, "strpos(): Offset not contained in string", new Object[0]);
            return Memory.FALSE;
        }
        if (haystackLen == 0) {
            return Memory.FALSE;
        }
        char ch = '\u0000';
        String search = null;
        if (needle.isString()) {
            search = needle.toString();
            if (search.length() == 1) {
                ch = search.charAt(0);
                search = null;
            }
        } else {
            ch = needle.toChar();
        }
        if (search == null) {
            p = haystack.indexOf(ch, offset);
        } else {
            if (search.isEmpty()) {
                env.warning(trace, "Empty needle", new Object[0]);
                return Memory.FALSE;
            }
            p = haystack.indexOf(search, offset);
        }
        if (p < 0) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(p);
    }

    @Runtime.Immutable
    public static Memory strpos(Environment env, TraceInfo trace, String haystack, Memory needle) {
        return StringFunctions.strpos(env, trace, haystack, needle, 0);
    }

    @Runtime.Immutable
    public static Memory strrpos(Environment env, TraceInfo trace, String haystack, Memory needle, int offset) {
        int p;
        int haystackLen = haystack.length();
        if (offset < 0 || offset > haystackLen) {
            env.warning(trace, "Offset not contained in string", new Object[0]);
            return Memory.FALSE;
        }
        if (haystackLen == 0) {
            return Memory.FALSE;
        }
        char ch = '\u0000';
        String search = null;
        if (needle.isString()) {
            search = needle.toString();
            if (search.length() == 1) {
                ch = search.charAt(0);
                search = null;
            }
        } else {
            ch = needle.toChar();
        }
        if (search == null) {
            p = haystack.lastIndexOf(ch, offset);
        } else {
            if (search.isEmpty()) {
                env.warning(trace, "Empty needle", new Object[0]);
                return Memory.FALSE;
            }
            p = haystack.lastIndexOf(search, offset);
        }
        if (p < 0) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(p);
    }

    @Runtime.Immutable
    public static Memory strrpos(Environment env, TraceInfo trace, String haystack, Memory needle) {
        return StringFunctions.strrpos(env, trace, haystack, needle, 0);
    }

    @Runtime.Immutable
    public static Memory strripos(Environment env, TraceInfo trace, String haystack, Memory needleV) {
        return StringFunctions.strripos(env, trace, haystack, needleV, null);
    }

    @Runtime.Immutable
    public static Memory strripos(Environment env, TraceInfo trace, String haystack, Memory needleV, Memory offsetV) {
        int offset;
        String needle = needleV.isString() ? needleV.toString() : String.valueOf((char)needleV.toInteger());
        if (offsetV == null) {
            offset = haystack.length();
        } else {
            offset = offsetV.toInteger();
            if (haystack.length() < offset) {
                env.warning(trace, "strripos(): offset cannot exceed string length", new Object[0]);
                return Memory.FALSE;
            }
        }
        haystack = haystack.toLowerCase();
        needle = needle.toLowerCase();
        int pos = haystack.lastIndexOf(needle, offset);
        if (pos < 0) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(pos);
    }

    @Runtime.Immutable
    public static Memory stripos(Environment env, TraceInfo trace, String haystack, Memory needle, int offset) {
        int haystackLen = haystack.length();
        if (offset < 0 || offset > haystackLen) {
            env.warning(trace, "stripos(): Offset not contained in string", new Object[0]);
            return Memory.FALSE;
        }
        if (haystackLen == 0) {
            return Memory.FALSE;
        }
        char ch = '\u0000';
        String search = null;
        if (needle.isString()) {
            search = needle.toString();
            if (search.length() == 1) {
                ch = Character.toUpperCase(search.charAt(0));
                search = null;
            }
        } else {
            ch = Character.toUpperCase(needle.toChar());
        }
        int p = -1;
        if (search == null) {
            for (int i = offset; i < haystackLen; ++i) {
                if (Character.toUpperCase(haystack.charAt(i)) != ch) continue;
                p = i;
                break;
            }
        } else {
            if (search.isEmpty()) {
                env.warning(trace, "Empty needle", new Object[0]);
                return Memory.FALSE;
            }
            p = StringUtils.indexOfIgnoreCase(haystack, search, offset);
        }
        if (p < 0) {
            return Memory.FALSE;
        }
        return LongMemory.valueOf(p);
    }

    @Runtime.Immutable
    public static Memory stripos(Environment env, TraceInfo trace, String haystack, Memory needle) {
        return StringFunctions.stripos(env, trace, haystack, needle, 0);
    }

    @Runtime.Immutable
    public static Memory strlen(Environment env, TraceInfo trace, Memory string) {
        if (string.isArray()) {
            env.warning(trace, "expects parameter 1 to be string, array given", new Object[0]);
            return Memory.NULL;
        }
        if (string instanceof BinaryMemory) {
            return LongMemory.valueOf(string.getBinaryBytes(env.getDefaultCharset()).length);
        }
        return LongMemory.valueOf(string.toString().length());
    }

    protected static String _substr_replace(String string, String replacement, int start, int length) {
        int strLength = string.length();
        if (start > strLength) {
            start = strLength;
        } else if (start < 0) {
            start = strLength + start;
        }
        if (start < 0) {
            start = 0;
        }
        int end = length < 0 ? Math.max(strLength + length, start) : (strLength < length ? strLength : start + length);
        StringBuilder result = new StringBuilder();
        result.append(string.substring(0, start));
        result.append(replacement);
        result.append(string.substring(end));
        return result.toString();
    }

    public static Memory str_replace(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string) {
        return StringFunctions.str_replace(env, trace, search, replace, string, Memory.UNDEFINED);
    }

    public static Memory str_replace(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string, @Runtime.Reference Memory _count) {
        return StringFunctions._str_replace(env, trace, search, replace, string, _count, false);
    }

    public static Memory str_ireplace(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string) {
        return StringFunctions.str_ireplace(env, trace, search, replace, string, Memory.UNDEFINED);
    }

    public static Memory str_ireplace(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string, @Runtime.Reference Memory _count) {
        return StringFunctions._str_replace(env, trace, search, replace, string, _count, true);
    }

    protected static Memory _str_replace_impl(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string, @Runtime.Reference Memory _count, boolean isInsensitive) {
        String searchText = search.toString();
        String replaceText = replace.toString();
        String text = string.toString();
        AtomicLong count = _count.isUndefined() ? null : new AtomicLong(_count.toLong());
        text = StringUtils.replace(text, searchText, replaceText, isInsensitive, count);
        if (count != null) {
            _count.assign(count.get());
        }
        return StringMemory.valueOf(text);
    }

    protected static Memory _str_replace(Environment env, TraceInfo trace, Memory search, Memory replace, Memory string, @Runtime.Reference Memory count, boolean isInsensitive) {
        if (count.isReference()) {
            count.assign(0L);
        }
        if (string.isNull()) {
            return Memory.CONST_EMPTY_STRING;
        }
        if (string.isArray()) {
            ForeachIterator iterator = string.getNewIterator(env);
            ArrayMemory result = new ArrayMemory();
            while (iterator.next()) {
                Memory key = iterator.getMemoryKey();
                Memory value = iterator.getValue();
                if (value.isArray()) {
                    result.refOfIndex(key).assign(value.toImmutable());
                    continue;
                }
                Memory ret = StringFunctions._str_replace(env, trace, search, replace, StringMemory.valueOf(value.toString()), count, isInsensitive);
                result.refOfIndex(key).assign(ret);
            }
            return result.toConstant();
        }
        if (!search.isArray()) {
            String searchStr = search.toString();
            if (searchStr.isEmpty()) {
                return string;
            }
            if (replace.isArray()) {
                env.warning(trace, "str_replace(): Array to string conversion", new Object[0]);
            }
            string = StringFunctions._str_replace_impl(env, trace, StringMemory.valueOf(searchStr), StringMemory.valueOf(replace.toString()), string, count, isInsensitive);
        } else if (replace.isArray()) {
            ForeachIterator searchIterator = search.getNewIterator(env);
            ForeachIterator replaceIterator = replace.getNewIterator(env);
            while (searchIterator.next()) {
                Memory searchValue = searchIterator.getValue();
                Memory replaceValue = replaceIterator.next() ? replaceIterator.getValue() : Memory.NULL;
                string = StringFunctions._str_replace(env, trace, StringMemory.valueOf(searchValue.toString()), StringMemory.valueOf(replaceValue.toString()), string, count, isInsensitive);
            }
        } else {
            ForeachIterator searchIterator = search.getNewIterator(env);
            while (searchIterator.next()) {
                string = StringFunctions._str_replace(env, trace, StringMemory.valueOf(searchIterator.getValue().toString()), replace, string, count, isInsensitive);
            }
        }
        return string;
    }

    @Runtime.Immutable
    public static Memory substr_replace(Environment env, TraceInfo trace, Memory string, Memory replacementM, Memory startM, Memory lengthM) {
        int start = 0;
        int length = 0x3FFFFFFF;
        String replacement = "";
        ForeachIterator replacementIterator = null;
        if (replacementM.isArray()) {
            replacementIterator = replacementM.getNewIterator(env, false, false);
        } else {
            replacement = replacementM.toString();
        }
        ForeachIterator startIterator = null;
        if (startM.isArray()) {
            startIterator = startM.getNewIterator(env, false, false);
        } else {
            start = startM.toInteger();
        }
        ForeachIterator lengthIterator = null;
        if (lengthM.isArray()) {
            lengthIterator = lengthM.getNewIterator(env, false, false);
        } else {
            length = lengthM.toInteger();
        }
        if (string.isArray()) {
            ArrayMemory resultArray = new ArrayMemory();
            ForeachIterator iterator = string.getNewIterator(env, false, false);
            while (iterator.next()) {
                String value = iterator.getValue().toString();
                if (replacementIterator != null && replacementIterator.next()) {
                    replacement = replacementIterator.getValue().toString();
                }
                if (lengthIterator != null && lengthIterator.next()) {
                    length = lengthIterator.getValue().toInteger();
                }
                if (startIterator != null && startIterator.next()) {
                    start = startIterator.getValue().toInteger();
                }
                String result = StringFunctions._substr_replace(value, replacement, start, length);
                resultArray.add(new StringMemory(result));
            }
            return resultArray.toConstant();
        }
        if (replacementIterator != null && replacementIterator.next()) {
            replacement = replacementIterator.getValue().toString();
        }
        if (lengthIterator != null && lengthIterator.next()) {
            length = lengthIterator.getValue().toInteger();
        }
        if (startIterator != null && startIterator.next()) {
            start = startIterator.getValue().toInteger();
        }
        return new StringMemory(StringFunctions._substr_replace(string.toString(), replacement, start, length));
    }

    @Runtime.Immutable
    public static Memory substr_replace(Environment env, TraceInfo trace, Memory string, Memory replacementM, Memory startM) {
        return StringFunctions.substr_replace(env, trace, string, replacementM, startM, LongMemory.valueOf(0x3FFFFFFF));
    }

    @Runtime.Immutable
    public static Memory wordwrap(String str, int width, String _break, boolean cut) {
        int length = str.length();
        StringBuilderMemory sb = new StringBuilderMemory();
        int done = 0;
        int prevSpacePos = 0;
        int start = 0;
        int wordLength = 0;
        for (int i = 0; i < length + 1; ++i) {
            char ch;
            char c = ch = i == length ? (char)' ' : (char)str.charAt(i);
            if (Character.isSpaceChar(ch) || cut && wordLength + 1 >= width) {
                if (done >= width || i == length) {
                    if (done <= width) {
                        sb.append(str.substring(start, i));
                    } else {
                        sb.append(str.substring(start, prevSpacePos));
                        i = prevSpacePos;
                    }
                    start = i + 1;
                    if (i != length) {
                        sb.append(_break);
                    }
                    done = 0;
                    continue;
                }
                prevSpacePos = i;
                wordLength = 0;
            }
            ++done;
            ++wordLength;
        }
        return sb;
    }

    @Runtime.Immutable
    public static Memory wordwrap(String str, int width, String _break) {
        return StringFunctions.wordwrap(str, width, _break, false);
    }

    @Runtime.Immutable
    public static Memory wordwrap(String str, int width) {
        return StringFunctions.wordwrap(str, width, "\n", false);
    }

    @Runtime.Immutable
    public static Memory wordwrap(String str) {
        return StringFunctions.wordwrap(str, 75, "\n", false);
    }

    @Runtime.Immutable
    public static String number_format(double number, int decimals, char decPoint, char thousandsSep) {
        DecimalFormatSymbols decimalFormatSymbols;
        String pattern;
        if (decimals > 0) {
            StringBuilder patternBuilder = new StringBuilder(6 + decimals);
            patternBuilder.append(thousandsSep == '\u0000' ? "###0." : "#,##0.");
            for (int i = 0; i < decimals; ++i) {
                patternBuilder.append('0');
            }
            pattern = patternBuilder.toString();
        } else {
            String string = pattern = thousandsSep == '\u0000' ? "###0" : "#,##0";
        }
        if (decPoint == '.' && thousandsSep == ',') {
            decimalFormatSymbols = DEFAULT_DECIMAL_FORMAT_SYMBOLS;
        } else {
            decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(decPoint);
            decimalFormatSymbols.setGroupingSeparator(thousandsSep);
            decimalFormatSymbols.setZeroDigit('0');
        }
        DecimalFormat format = new DecimalFormat(pattern, decimalFormatSymbols);
        String result = format.format(number);
        if (decPoint == '\u0000' && decimals > 0) {
            int i = result.lastIndexOf(decPoint);
            return result.substring(0, i) + result.substring(i + 1, result.length());
        }
        return result;
    }

    @Runtime.Immutable
    public static String number_format(double number, int decimals) {
        return StringFunctions.number_format(number, decimals, '.', ',');
    }

    @Runtime.Immutable
    public static String number_format(double number) {
        return StringFunctions.number_format(number, 0, '.', ',');
    }

    @Runtime.Immutable
    public static String str_repeat(String input, int multiplier) {
        if (multiplier <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < multiplier; ++i) {
            sb.append(input);
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String str_pad(String string, int length, String pad, int type) {
        int i;
        int strLen = string.length();
        int padLen = length - strLen;
        if (padLen <= 0) {
            return string;
        }
        if (pad == null || pad.length() == 0) {
            pad = " ";
        }
        int leftPad = 0;
        int rightPad = 0;
        switch (type) {
            case 0: {
                leftPad = padLen;
                break;
            }
            default: {
                rightPad = padLen;
                break;
            }
            case 2: {
                leftPad = padLen / 2;
                rightPad = padLen - leftPad;
            }
        }
        int padStringLen = pad.length();
        StringBuilder sb = new StringBuilder(string.length() + padLen);
        for (i = 0; i < leftPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        sb = sb.append(string);
        for (i = 0; i < rightPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String str_pad(String string, int length, String pad) {
        return StringFunctions.str_pad(string, length, pad, StringFunctions.constants.STR_PAD_RIGHT);
    }

    @Runtime.Immutable
    public static String str_pad(String string, int length) {
        return StringFunctions.str_pad(string, length, " ", StringFunctions.constants.STR_PAD_RIGHT);
    }

    @Runtime.Immutable
    public static int crc32(Environment env, Memory value) {
        CRC32 crc = new CRC32();
        crc.update(value.getBinaryBytes(env.getDefaultCharset()));
        return (int)crc.getValue();
    }

    @Runtime.Immutable
    public static String nl2br(String string, boolean isXhtml) {
        String br = "<br />";
        if (!isXhtml) {
            br = "<br>";
        }
        return string.replaceAll("(\\r?\\n)", br + "$1");
    }

    @Runtime.Immutable
    public static String htmlspecialchars_decode(String string) {
        return StringFunctions.htmlspecialchars_decode(string, 2);
    }

    @Runtime.Immutable
    public static String htmlspecialchars_decode(String string, int quoteStyle) {
        int len = string.length();
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch != '&') {
                sb.append(ch);
                continue;
            }
            switch (string.charAt(i + 1)) {
                case 'a': {
                    sb.append('&');
                    if (i + 4 >= len || string.charAt(i + 2) != 'm' || string.charAt(i + 3) != 'p' || string.charAt(i + 4) != ';') continue block7;
                    i += 4;
                    continue block7;
                }
                case 'q': {
                    if ((quoteStyle & 2) != 0 && i + 5 < len && string.charAt(i + 2) == 'u' && string.charAt(i + 3) == 'o' && string.charAt(i + 4) == 't' && string.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\"');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case '#': {
                    if ((quoteStyle & 1) != 0 && i + 5 < len && string.charAt(i + 2) == '0' && string.charAt(i + 3) == '3' && string.charAt(i + 4) == '9' && string.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\'');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'l': {
                    if (i + 3 < len && string.charAt(i + 2) == 't' && string.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('<');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'g': {
                    if (i + 3 < len && string.charAt(i + 2) == 't' && string.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('>');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    sb.append('&');
                }
            }
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static Memory htmlspecialchars(Environment env, TraceInfo trace, Memory _string, int quoteStyle) {
        return StringFunctions.htmlspecialchars(env, trace, _string, quoteStyle, "UTF-8");
    }

    @Runtime.Immutable
    public static Memory htmlspecialchars(Environment env, TraceInfo trace, Memory _string) {
        return StringFunctions.htmlspecialchars(env, trace, _string, 2, "UTF-8");
    }

    public static Memory htmlspecialchars(Environment env, TraceInfo trace, Memory _string, int quoteStyle, String charset) {
        try {
            String string = new String(_string.getBinaryBytes(env.getDefaultCharset()), charset);
            int len = string.length();
            StringBuilderMemory sb = new StringBuilderMemory();
            block9: for (int i = 0; i < len; ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '&': {
                        sb.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        if ((quoteStyle & 2) != 0) {
                            sb.append("&quot;");
                            continue block9;
                        }
                        sb.append(ch);
                        continue block9;
                    }
                    case '\'': {
                        if ((quoteStyle & 2) != 0) {
                            sb.append("&#039;");
                            continue block9;
                        }
                        sb.append(ch);
                        continue block9;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block9;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return sb;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(trace, "htmlspecialchars(): unsupported encoding - %s", charset);
            return Memory.FALSE;
        }
    }

    @Runtime.Immutable
    public static Memory html_entity_decode(Environment env, TraceInfo trace, Memory _string, int flags, String encoding) {
        try {
            String string = new String(_string.getBinaryBytes(env.getDefaultCharset()), encoding);
            int len = string.length();
            int htmlEntityStart = -1;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                char ch = string.charAt(i);
                if (ch == '&' && htmlEntityStart < 0) {
                    htmlEntityStart = i;
                    continue;
                }
                if (htmlEntityStart < 0) {
                    result.append(ch);
                    continue;
                }
                if (ch == ';') {
                    String entity = string.substring(htmlEntityStart, i + 1);
                    ReferenceMemory value = HTML_ENTITIES.getByScalar(entity);
                    if (value == null) {
                        result.append(entity);
                    } else {
                        result.append(value);
                    }
                    htmlEntityStart = -1;
                    continue;
                }
                if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') continue;
                result.append('&');
                i = htmlEntityStart;
                htmlEntityStart = -1;
            }
            if (htmlEntityStart > 0) {
                result.append(string, htmlEntityStart, len);
            }
            return new StringMemory(result.toString());
        }
        catch (UnsupportedEncodingException e) {
            env.warning(trace, "html_entity_decode(): unsupported encoding - %s", encoding);
            return Memory.FALSE;
        }
    }

    public static Memory htmlentities(Environment env, TraceInfo trace, Memory _string, int quoteStyle, String encoding) {
        try {
            String string = new String(_string.getBinaryBytes(env.getDefaultCharset()), encoding);
            StringBuffer sb = new StringBuffer();
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                char ch = string.charAt(i);
                ReferenceMemory el = HTML_ENTITIES.getByScalar(String.valueOf(ch));
                if (ch == '\"') {
                    if ((quoteStyle & 2) != 0) {
                        sb.append("&quot;");
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                if (ch == '\'') {
                    if ((quoteStyle & 1) != 0) {
                        sb.append("&#039;");
                        continue;
                    }
                    sb.append('\'');
                    continue;
                }
                if (el != null) {
                    sb.append(el);
                    continue;
                }
                sb.append(ch);
            }
            return new StringMemory(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            env.warning(trace, "htmlentities(): unsupported encoding - %s", encoding);
            return Memory.FALSE;
        }
    }

    @Runtime.Immutable
    public static int levenshtein(String str1, String str2) {
        return StringFunctions.levenshtein(str1, str2, 1, 1, 1);
    }

    @Runtime.Immutable
    public static int levenshtein(String s1, String s2, int cost_ins, int cost_rep, int cost_del) {
        int i;
        int flip;
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 > 255) {
            return -1;
        }
        if (l2 > 255) {
            return -1;
        }
        int cr = cost_rep;
        int ci = cost_ins;
        int cd = cost_del;
        int cutHalf = flip = Math.max(l1, l2);
        int minCost = Math.min(Math.min(cd, ci), cr);
        int minD = Math.max(minCost, (l1 - l2) * cd);
        int minI = Math.max(minCost, (l2 - l1) * ci);
        int[] buf = new int[cutHalf * 2 + 1];
        for (i = 0; i <= l2; ++i) {
            buf[i] = i * minD;
        }
        for (i = 0; i < l1; ++i) {
            char ch = s1.charAt(i);
            buf[flip] = (i + 1) * minI;
            int ii = flip;
            int ii2 = cutHalf - flip;
            int j = 0;
            while (j < l2) {
                int cost = ch == s2.charAt(j) ? 0 : cr;
                buf[ii + 1] = Math.min(Math.min(buf[ii2 + 1] + cd, buf[ii] + ci), buf[ii2] + cost);
                ++j;
                ++ii;
                ++ii2;
            }
            flip = cutHalf - flip;
        }
        return buf[l2 + cutHalf - flip];
    }

    @Runtime.Immutable
    public static Memory convert_uudecode(String source) {
        char ch1;
        int length = source.length();
        if (length == 0) {
            return Memory.FALSE;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length && (ch1 = source.charAt(i++)) != '`' && ch1 != ' ') {
            if (ch1 < ' ' || '_' < ch1) continue;
            for (int sublen = ch1 - 32; sublen > 0; sublen -= 3) {
                int code = (source.charAt(i++) - 32 & 0x3F) << 18;
                code += (source.charAt(i++) - 32 & 0x3F) << 12;
                code += (source.charAt(i++) - 32 & 0x3F) << 6;
                builder.append((code += source.charAt(i++) - 32 & 0x3F) >> 16);
                if (sublen > 1) {
                    builder.append(code >> 8);
                }
                if (sublen <= 2) continue;
                builder.append(code);
            }
        }
        return new StringMemory(builder.toString());
    }

    @Runtime.Immutable
    public static Memory convert_uuencode(String source) {
        if (source.length() == 0) {
            return Memory.FALSE;
        }
        StringBuilderMemory result = new StringBuilderMemory();
        int i = 0;
        int length = source.length();
        while (i < length) {
            int sublen = length - i;
            if (45 < sublen) {
                sublen = 45;
            }
            result.append((char)(sublen + 32));
            int end = i + sublen;
            while (i < end) {
                int code = source.charAt(i++) << 16;
                if (i < length) {
                    code += source.charAt(i++) << 8;
                }
                if (i < length) {
                    code += source.charAt(i++);
                }
                result.append(StringFunctions.toUUChar(code >> 18 & 0x3F));
                result.append(StringFunctions.toUUChar(code >> 12 & 0x3F));
                result.append(StringFunctions.toUUChar(code >> 6 & 0x3F));
                result.append(StringFunctions.toUUChar(code & 0x3F));
            }
            result.append(10L);
        }
        result.append(96L);
        result.append(10L);
        return result;
    }

    @Runtime.Immutable
    public static String metaphone(String string) {
        int index;
        int length = string.length();
        char ch = '\u0000';
        for (index = 0; index < length && ('A' > (ch = StringFunctions.toUpperCase(string.charAt(index))) || ch > 'Z'); ++index) {
        }
        if (index == length) {
            return "";
        }
        int lastIndex = length - 1;
        StringBuilder result = new StringBuilder(length);
        char nextCh = index < lastIndex ? StringFunctions.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
        block0 : switch (ch) {
            case 'A': {
                if (nextCh == 'E') {
                    result.append('E');
                    index += 2;
                    break;
                }
                result.append('A');
                ++index;
                break;
            }
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                result.append(ch);
                ++index;
                break;
            }
            case 'G': 
            case 'K': 
            case 'P': {
                if (nextCh != 'N') break;
                result.append('N');
                index += 2;
                break;
            }
            case 'W': {
                if (nextCh == 'H' || nextCh == 'R') {
                    result.append(nextCh);
                    index += 2;
                    break;
                }
                switch (nextCh) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        result.append('W');
                        index += 2;
                        break block0;
                    }
                }
                break;
            }
            case 'X': {
                result.append('S');
                ++index;
                break;
            }
        }
        while (index < length) {
            char prevCh = index > 0 ? StringFunctions.toUpperCase(string.charAt(index - 1)) : (char)'\u0000';
            ch = StringFunctions.toUpperCase(string.charAt(index));
            if (ch >= 'A' && ch <= 'Z' && (ch != prevCh || ch == 'C')) {
                nextCh = index + 1 < length ? StringFunctions.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
                char nextnextCh = index + 2 < length ? StringFunctions.toUpperCase(string.charAt(index + 2)) : (char)'\u0000';
                block10 : switch (ch) {
                    case 'B': {
                        if (prevCh == 'M') break;
                        result.append('B');
                        break;
                    }
                    case 'C': {
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                if (nextCh == 'I' && nextnextCh == 'A') {
                                    result.append('X');
                                    break;
                                }
                                if (prevCh == 'S') break;
                                result.append('S');
                                break;
                            }
                            default: {
                                if (nextCh == 'H') {
                                    result.append('X');
                                    ++index;
                                    break;
                                }
                                result.append('K');
                                break;
                            }
                        }
                        break;
                    }
                    case 'D': {
                        if (nextCh == 'G') {
                            switch (nextnextCh) {
                                case 'E': 
                                case 'I': 
                                case 'Y': {
                                    result.append('J');
                                    ++index;
                                    break block10;
                                }
                            }
                            result.append('T');
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'G': {
                        if (nextCh == 'H') {
                            boolean isSilent = false;
                            if (index - 3 >= 0) {
                                char prev3Ch = StringFunctions.toUpperCase(string.charAt(index - 3));
                                switch (prev3Ch) {
                                    case 'B': 
                                    case 'D': 
                                    case 'H': {
                                        isSilent = true;
                                        break;
                                    }
                                }
                            }
                            if (!isSilent && index - 4 >= 0) {
                                char prev4Ch = StringFunctions.toUpperCase(string.charAt(index - 4));
                                boolean bl = isSilent = prev4Ch == 'H';
                            }
                            if (isSilent) break;
                            result.append('F');
                            ++index;
                            break;
                        }
                        if (nextCh == 'N') {
                            char nextnextnextCh = index + 3 < length ? StringFunctions.toUpperCase(string.charAt(index + 3)) : (char)'\u0000';
                            if (nextnextCh < 'A' || nextnextCh > 'Z' || nextnextCh == 'E' && nextnextnextCh == 'D') break;
                            result.append('K');
                            break;
                        }
                        if (prevCh == 'G') {
                            result.append('K');
                            break;
                        }
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                result.append('J');
                                break block10;
                            }
                        }
                        result.append('K');
                        break;
                    }
                    case 'H': 
                    case 'W': 
                    case 'Y': {
                        switch (nextCh) {
                            case 'A': 
                            case 'E': 
                            case 'I': 
                            case 'O': 
                            case 'U': {
                                if (ch == 'H') {
                                    switch (prevCh) {
                                        case 'C': 
                                        case 'G': 
                                        case 'P': 
                                        case 'S': 
                                        case 'T': {
                                            break block10;
                                        }
                                    }
                                    result.append('H');
                                    break block10;
                                }
                                result.append(ch);
                                break block10;
                            }
                        }
                        break;
                    }
                    case 'K': {
                        if (prevCh == 'C') break;
                        result.append('K');
                        break;
                    }
                    case 'P': {
                        if (nextCh == 'H') {
                            result.append('F');
                            break;
                        }
                        result.append('P');
                        break;
                    }
                    case 'Q': {
                        result.append('K');
                        break;
                    }
                    case 'S': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('X');
                            ++index;
                            break;
                        }
                        result.append('S');
                        break;
                    }
                    case 'T': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('0');
                            ++index;
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'V': {
                        result.append('F');
                        break;
                    }
                    case 'X': {
                        result.append('K');
                        result.append('S');
                        break;
                    }
                    case 'Z': {
                        result.append('S');
                        break;
                    }
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        result.append(ch);
                        break;
                    }
                }
            }
            ++index;
        }
        return result.toString();
    }

    @Runtime.Immutable
    public static Memory strspn(String string, String characters, int offset, int length) {
        return StringFunctions.strspnImpl(string, characters, offset, length, true);
    }

    @Runtime.Immutable
    public static Memory strspn(String string, String characters, int offset) {
        return StringFunctions.strspnImpl(string, characters, offset, Integer.MIN_VALUE, true);
    }

    @Runtime.Immutable
    public static Memory strspn(String string, String characters) {
        return StringFunctions.strspnImpl(string, characters, 0, Integer.MIN_VALUE, true);
    }

    private static Memory strspnImpl(String string, String characters, int offset, int length, boolean isMatch) {
        int strlen = string.length();
        if (offset < 0 && (offset += strlen) < 0) {
            offset = 0;
        }
        if (offset > strlen) {
            return Memory.FALSE;
        }
        if (length == Integer.MIN_VALUE) {
            length = strlen;
        } else if (length < 0 && (length += strlen - offset) < 0) {
            length = 0;
        }
        int end = offset + length;
        if (strlen < end) {
            end = strlen;
        }
        int count = 0;
        while (offset < end) {
            boolean isPresent;
            char ch = string.charAt(offset);
            boolean bl = isPresent = characters.indexOf(ch) > -1;
            if (isPresent == isMatch) {
                ++count;
            } else {
                return LongMemory.valueOf(count);
            }
            ++offset;
        }
        return LongMemory.valueOf(count);
    }

    @Runtime.Immutable
    public static Memory strpbrk(String haystack, String charList) {
        int len = haystack.length();
        int sublen = charList.length();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < sublen; ++j) {
                if (haystack.charAt(i) != charList.charAt(j)) continue;
                return new StringMemory(haystack.substring(i));
            }
        }
        return Memory.FALSE;
    }

    @Runtime.Immutable
    public static Memory stristr(String haystack, Memory needleV) {
        String needleLower;
        if (needleV.isString()) {
            needleLower = needleV.toString().toLowerCase();
        } else {
            char lower = Character.toLowerCase((char)needleV.toLong());
            needleLower = String.valueOf(lower);
        }
        String haystackLower = haystack.toLowerCase();
        int i = haystackLower.indexOf(needleLower);
        if (i >= 0) {
            return new StringMemory(haystack.substring(i));
        }
        return Memory.FALSE;
    }

    @Runtime.Immutable
    public static String stripslashes(String string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= len) continue;
                char ch2 = string.charAt(i + 1);
                if (ch2 == '0') {
                    ch2 = '\u0000';
                }
                sb.append(ch2);
                ++i;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Runtime.Immutable
    public static String stripcslashes(String source) {
        StringBuilder result = new StringBuilder(source.length());
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            int ch = source.charAt(i);
            if (ch == 92) {
                if (++i == length) {
                    ch = 92;
                } else {
                    ch = source.charAt(i);
                    switch (ch) {
                        case 97: {
                            ch = 7;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 118: {
                            ch = 11;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 120: {
                            int digitValue;
                            if (i + 1 == length || (digitValue = StringFunctions.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = digitValue;
                            if (++i + 1 == length || (digitValue = StringFunctions.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 4 | digitValue;
                            ++i;
                            break;
                        }
                        default: {
                            int digitValue = StringFunctions.octToDigit((char)ch);
                            if (digitValue < 0) break;
                            ch = digitValue;
                            if (i + 1 == length || (digitValue = StringFunctions.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            if (++i + 1 == length || (digitValue = StringFunctions.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            ++i;
                        }
                    }
                }
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    @Runtime.Immutable
    public static String strip_tags(String string) {
        return StringFunctions.strip_tags(string, null);
    }

    @Runtime.Immutable
    public static String strip_tags(String string, Memory allowTags) {
        StringBuilder result = new StringBuilder();
        Set<String> allowedTagMap = null;
        if (allowTags != null) {
            allowedTagMap = StringFunctions.getAllowedTags(allowTags.toString());
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int j;
            char ch = string.charAt(i);
            if (i + 1 >= len || ch != '<') {
                result.append(ch);
                continue;
            }
            ch = string.charAt(i + 1);
            if (Character.isWhitespace(ch)) {
                ++i;
                result.append('<');
                result.append(ch);
                continue;
            }
            int tagNameStart = i + 1;
            if (ch == '/') {
                // empty if block
            }
            for (j = ++tagNameStart; j < len && (ch = string.charAt(j)) != '>' && !Character.isWhitespace(ch); ++j) {
            }
            String tagName = string.substring(tagNameStart, j);
            int tagEnd = 0;
            if (allowedTagMap != null && allowedTagMap.contains(tagName)) {
                result.append(string, i, Math.min(j + 1, len));
            } else {
                while (j < len && (ch = string.charAt(j)) != '<') {
                    if (ch == '>') {
                        tagEnd = j;
                    }
                    ++j;
                }
            }
            i = tagEnd != 0 ? tagEnd : j;
        }
        return result.toString();
    }

    private static Set<String> getAllowedTags(String str) {
        int len = str.length();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    int j;
                    for (j = i + 1; j < len && (ch = str.charAt(j)) != '>' && !Character.isWhitespace(ch); ++j) {
                    }
                    if (ch == '>' && i + 1 < j && j < len) {
                        set.add(str.substring(i + 1, j));
                    }
                    i = j;
                }
            }
        }
        return set;
    }

    public static Memory str_word_count(String string, int format, String additionalWordCharacters) {
        if (format < 0 || format > 2) {
            return Memory.NULL;
        }
        int strlen = string.length();
        boolean isAdditionalWordCharacters = false;
        if (additionalWordCharacters != null) {
            isAdditionalWordCharacters = additionalWordCharacters.length() > 0;
        }
        ArrayMemory resultArray = null;
        if (format > 0) {
            resultArray = new ArrayMemory();
        }
        boolean isBetweenWords = true;
        int wordCount = 0;
        int lastWordStart = 0;
        for (int i = 0; i <= strlen; ++i) {
            char ch;
            boolean isWordCharacter = i < strlen ? Character.isLetter((int)(ch = string.charAt(i))) || ch == '-' || ch == '\'' || isAdditionalWordCharacters && additionalWordCharacters.indexOf(ch) > -1 : false;
            if (isWordCharacter) {
                if (!isBetweenWords) continue;
                isBetweenWords = false;
                lastWordStart = i;
                ++wordCount;
                continue;
            }
            if (isBetweenWords) continue;
            isBetweenWords = true;
            if (format <= 0) continue;
            String word = string.substring(lastWordStart, i);
            if (format == 1) {
                resultArray.add(new StringMemory(word));
                continue;
            }
            if (format != 2) continue;
            resultArray.refOfIndex(lastWordStart).assign(word);
        }
        if (resultArray == null) {
            return LongMemory.valueOf(wordCount);
        }
        return resultArray.toConstant();
    }

    public static String base64_encode(Environment env, Memory value) {
        return DatatypeConverter.printBase64Binary((byte[])value.getBinaryBytes(env.getDefaultCharset()));
    }

    public static Memory base64_decode(String value) {
        try {
            return new BinaryMemory(DatatypeConverter.parseBase64Binary((String)value));
        }
        catch (IllegalArgumentException e) {
            return Memory.FALSE;
        }
    }

    public static Memory parse_url(String url, int component) {
        try {
            URI uri = URI.create(url);
            switch (component) {
                case 0: {
                    return uri.getScheme() == null ? Memory.NULL : StringMemory.valueOf(uri.getScheme());
                }
                case 1: {
                    return uri.getHost() == null ? Memory.NULL : StringMemory.valueOf(uri.getHost());
                }
                case 2: {
                    return uri.getPort() == -1 ? Memory.NULL : LongMemory.valueOf(uri.getPort());
                }
                case 3: 
                case 4: {
                    return uri.getUserInfo() != null ? Memory.NULL : StringMemory.valueOf(uri.getUserInfo());
                }
                case 5: {
                    return uri.getPath() != null ? Memory.NULL : StringMemory.valueOf(uri.getPath());
                }
                case 6: {
                    return uri.getQuery() != null ? Memory.NULL : StringMemory.valueOf(uri.getQuery());
                }
                case 7: {
                    return uri.getFragment() != null ? Memory.NULL : StringMemory.valueOf(uri.getFragment());
                }
                case -1: {
                    ArrayMemory result = new ArrayMemory();
                    if (uri.getScheme() != null) {
                        result.refOfIndex("scheme").assign(uri.getScheme());
                    }
                    if (uri.getHost() != null) {
                        result.refOfIndex("host").assign(uri.getHost());
                    }
                    if (uri.getPort() != -1) {
                        result.refOfIndex("port").assign(uri.getPort());
                    }
                    if (uri.getPath() != null) {
                        result.refOfIndex("path").assign(uri.getPath());
                    }
                    if (uri.getUserInfo() != null) {
                        result.refOfIndex("user").assign(uri.getUserInfo());
                    }
                    if (uri.getQuery() != null) {
                        result.refOfIndex("query").assign(uri.getQuery());
                    }
                    if (uri.getFragment() != null) {
                        result.refOfIndex("fragment").assign(uri.getFragment());
                    }
                    return result.toConstant();
                }
            }
            return Memory.FALSE;
        }
        catch (IllegalArgumentException e) {
            return Memory.FALSE;
        }
    }

    public static Memory parse_url(String url) {
        return StringFunctions.parse_url(url, -1);
    }

    public static String uniqid(String prefix) {
        return prefix + UUID.fromString(String.valueOf(System.currentTimeMillis())).toString().replace("-", "");
    }

    public static String uniqid() {
        return StringFunctions.uniqid("");
    }

    public static String urldecode(String url) throws UnsupportedEncodingException {
        return URLDecoder.decode(url, "UTF-8");
    }

    public static String urlencode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF-8");
    }

    public static String rawurlencode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public static String rawurldecode(String url) throws UnsupportedEncodingException {
        return URLDecoder.decode(url, "UTF-8").replace("%20", "+").replace("%2A", "*").replace("~", "%7E");
    }

    public static void setLocale() {
    }

    public static void dl(String extension) {
    }

    public static int strnatcmp(String one, String two) {
        return new NaturalOrderComparator(false, false).compare(one, two);
    }

    public static int strnatcasecmp(String one, String two) {
        return new NaturalOrderComparator(true, false).compare(one, two);
    }

    static {
        constants = new StringConstants();
        SOUNDEX_VALUES = "01230120022455012623010202".toCharArray();
        md5Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        sha1Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("SHA1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        DEFAULT_DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols();
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setDecimalSeparator('.');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setGroupingSeparator(',');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setZeroDigit('0');
        HTML_ENTITIES = new ArrayMemory();
        HTML_ENTITIES.put("\"", new StringMemory("&quot;"));
        HTML_ENTITIES.put("&", new StringMemory("&amp;"));
        HTML_ENTITIES.put("\"", new StringMemory("&#039;"));
        HTML_ENTITIES.put("<", new StringMemory("&lt;"));
        HTML_ENTITIES.put(">", new StringMemory("&gt;"));
        HTML_ENTITIES.put("\u00a0", new StringMemory("&nbsp;"));
        HTML_ENTITIES.put("\u00a1", new StringMemory("&iexcl;"));
        HTML_ENTITIES.put("\u00a2", new StringMemory("&cent;"));
        HTML_ENTITIES.put("\u00a3", new StringMemory("&pound;"));
        HTML_ENTITIES.put("\u00a4", new StringMemory("&curren;"));
        HTML_ENTITIES.put("\u00a5", new StringMemory("&yen;"));
        HTML_ENTITIES.put("\u00a6", new StringMemory("&brvbar;"));
        HTML_ENTITIES.put("\u00a7", new StringMemory("&sect;"));
        HTML_ENTITIES.put("\u00a8", new StringMemory("&uml;"));
        HTML_ENTITIES.put("\u00a9", new StringMemory("&copy;"));
        HTML_ENTITIES.put("\u00aa", new StringMemory("&ordf;"));
        HTML_ENTITIES.put("\u00ab", new StringMemory("&laquo;"));
        HTML_ENTITIES.put("\u00ac", new StringMemory("&not;"));
        HTML_ENTITIES.put("\u00ad", new StringMemory("&shy;"));
        HTML_ENTITIES.put("\u00ae", new StringMemory("&reg;"));
        HTML_ENTITIES.put("\u00af", new StringMemory("&macr;"));
        HTML_ENTITIES.put("\u00b0", new StringMemory("&deg;"));
        HTML_ENTITIES.put("\u00b1", new StringMemory("&plusmn;"));
        HTML_ENTITIES.put("\u00b2", new StringMemory("&sup2;"));
        HTML_ENTITIES.put("\u00b3", new StringMemory("&sup3;"));
        HTML_ENTITIES.put("\u00b4", new StringMemory("&acute;"));
        HTML_ENTITIES.put("\u00b5", new StringMemory("&micro;"));
        HTML_ENTITIES.put("\u00b6", new StringMemory("&para;"));
        HTML_ENTITIES.put("\u00b7", new StringMemory("&middot;"));
        HTML_ENTITIES.put("\u00b8", new StringMemory("&cedil;"));
        HTML_ENTITIES.put("\u00b9", new StringMemory("&sup1;"));
        HTML_ENTITIES.put("\u00ba", new StringMemory("&ordm;"));
        HTML_ENTITIES.put("\u00bb", new StringMemory("&raquo;"));
        HTML_ENTITIES.put("\u00bc", new StringMemory("&frac14;"));
        HTML_ENTITIES.put("\u00bd", new StringMemory("&frac12;"));
        HTML_ENTITIES.put("\u00be", new StringMemory("&frac34;"));
        HTML_ENTITIES.put("\u00bf", new StringMemory("&iquest;"));
        HTML_ENTITIES.put("\u00c0", new StringMemory("&Agrave;"));
        HTML_ENTITIES.put("\u00c1", new StringMemory("&Aacute;"));
        HTML_ENTITIES.put("\u00c2", new StringMemory("&Acirc;"));
        HTML_ENTITIES.put("\u00c3", new StringMemory("&Atilde;"));
        HTML_ENTITIES.put("\u00c4", new StringMemory("&Auml;"));
        HTML_ENTITIES.put("\u00c5", new StringMemory("&Aring;"));
        HTML_ENTITIES.put("\u00c6", new StringMemory("&AElig;"));
        HTML_ENTITIES.put("\u00c7", new StringMemory("&Ccedil;"));
        HTML_ENTITIES.put("\u00c8", new StringMemory("&Egrave;"));
        HTML_ENTITIES.put("\u00c9", new StringMemory("&Eacute;"));
        HTML_ENTITIES.put("\u00ca", new StringMemory("&Ecirc;"));
        HTML_ENTITIES.put("\u00cb", new StringMemory("&Euml;"));
        HTML_ENTITIES.put("\u00cc", new StringMemory("&Igrave;"));
        HTML_ENTITIES.put("\u00cd", new StringMemory("&Iacute;"));
        HTML_ENTITIES.put("\u00ce", new StringMemory("&Icirc;"));
        HTML_ENTITIES.put("\u00cf", new StringMemory("&Iuml;"));
        HTML_ENTITIES.put("\u00d0", new StringMemory("&ETH;"));
        HTML_ENTITIES.put("\u00d1", new StringMemory("&Ntilde;"));
        HTML_ENTITIES.put("\u00d2", new StringMemory("&Ograve;"));
        HTML_ENTITIES.put("\u00d3", new StringMemory("&Oacute;"));
        HTML_ENTITIES.put("\u00d4", new StringMemory("&Ocirc;"));
        HTML_ENTITIES.put("\u00d5", new StringMemory("&Otilde;"));
        HTML_ENTITIES.put("\u00d6", new StringMemory("&Ouml;"));
        HTML_ENTITIES.put("\u00d7", new StringMemory("&times;"));
        HTML_ENTITIES.put("\u00d8", new StringMemory("&Oslash;"));
        HTML_ENTITIES.put("\u00d9", new StringMemory("&Ugrave;"));
        HTML_ENTITIES.put("\u00da", new StringMemory("&Uacute;"));
        HTML_ENTITIES.put("\u00db", new StringMemory("&Ucirc;"));
        HTML_ENTITIES.put("\u00dc", new StringMemory("&Uuml;"));
        HTML_ENTITIES.put("\u00dd", new StringMemory("&Yacute;"));
        HTML_ENTITIES.put("\u00de", new StringMemory("&THORN;"));
        HTML_ENTITIES.put("\u00df", new StringMemory("&szlig;"));
        HTML_ENTITIES.put("\u00e0", new StringMemory("&agrave;"));
        HTML_ENTITIES.put("\u00e1", new StringMemory("&aacute;"));
        HTML_ENTITIES.put("\u00e2", new StringMemory("&acirc;"));
        HTML_ENTITIES.put("\u00e3", new StringMemory("&atilde;"));
        HTML_ENTITIES.put("\u00e4", new StringMemory("&auml;"));
        HTML_ENTITIES.put("\u00e5", new StringMemory("&aring;"));
        HTML_ENTITIES.put("\u00e6", new StringMemory("&aelig;"));
        HTML_ENTITIES.put("\u00e7", new StringMemory("&ccedil;"));
        HTML_ENTITIES.put("\u00e8", new StringMemory("&egrave;"));
        HTML_ENTITIES.put("\u00e9", new StringMemory("&eacute;"));
        HTML_ENTITIES.put("\u00ea", new StringMemory("&ecirc;"));
        HTML_ENTITIES.put("\u00eb", new StringMemory("&euml;"));
        HTML_ENTITIES.put("\u00ec", new StringMemory("&igrave;"));
        HTML_ENTITIES.put("\u00ed", new StringMemory("&iacute;"));
        HTML_ENTITIES.put("\u00ee", new StringMemory("&icirc;"));
        HTML_ENTITIES.put("\u00ef", new StringMemory("&iuml;"));
        HTML_ENTITIES.put("\u00f0", new StringMemory("&eth;"));
        HTML_ENTITIES.put("\u00f1", new StringMemory("&ntilde;"));
        HTML_ENTITIES.put("\u00f2", new StringMemory("&ograve;"));
        HTML_ENTITIES.put("\u00f3", new StringMemory("&oacute;"));
        HTML_ENTITIES.put("\u00f4", new StringMemory("&ocirc;"));
        HTML_ENTITIES.put("\u00f5", new StringMemory("&otilde;"));
        HTML_ENTITIES.put("\u00f6", new StringMemory("&ouml;"));
        HTML_ENTITIES.put("\u00f7", new StringMemory("&divide;"));
        HTML_ENTITIES.put("\u00f8", new StringMemory("&oslash;"));
        HTML_ENTITIES.put("\u00f9", new StringMemory("&ugrave;"));
        HTML_ENTITIES.put("\u00fa", new StringMemory("&uacute;"));
        HTML_ENTITIES.put("\u00fb", new StringMemory("&ucirc;"));
        HTML_ENTITIES.put("\u00fc", new StringMemory("&uuml;"));
        HTML_ENTITIES.put("\u00fd", new StringMemory("&yacute;"));
        HTML_ENTITIES.put("\u00fe", new StringMemory("&thorn;"));
        HTML_ENTITIES.put("\u00ff", new StringMemory("&yuml;"));
        HTML_ENTITIES.put("\u0152", new StringMemory("&OElig;"));
        HTML_ENTITIES.put("\u0153", new StringMemory("&oelig;"));
        HTML_ENTITIES.put("\u0160", new StringMemory("&Scaron;"));
        HTML_ENTITIES.put("\u0161", new StringMemory("&scaron;"));
        HTML_ENTITIES.put("\u0178", new StringMemory("&Yuml;"));
        HTML_ENTITIES.put("\u0192", new StringMemory("&fnof;"));
        HTML_ENTITIES.put("\u02c6", new StringMemory("&circ;"));
        HTML_ENTITIES.put("\u02dc", new StringMemory("&tilde;"));
        HTML_ENTITIES.put("\u0391", new StringMemory("&Alpha;"));
        HTML_ENTITIES.put("\u0392", new StringMemory("&Beta;"));
        HTML_ENTITIES.put("\u0393", new StringMemory("&Gamma;"));
        HTML_ENTITIES.put("\u0394", new StringMemory("&Delta;"));
        HTML_ENTITIES.put("\u0395", new StringMemory("&Epsilon;"));
        HTML_ENTITIES.put("\u0396", new StringMemory("&Zeta;"));
        HTML_ENTITIES.put("\u0397", new StringMemory("&Eta;"));
        HTML_ENTITIES.put("\u0398", new StringMemory("&Theta;"));
        HTML_ENTITIES.put("\u0399", new StringMemory("&Iota;"));
        HTML_ENTITIES.put("\u039a", new StringMemory("&Kappa;"));
        HTML_ENTITIES.put("\u039b", new StringMemory("&Lambda;"));
        HTML_ENTITIES.put("\u039c", new StringMemory("&Mu;"));
        HTML_ENTITIES.put("\u039d", new StringMemory("&Nu;"));
        HTML_ENTITIES.put("\u039e", new StringMemory("&Xi;"));
        HTML_ENTITIES.put("\u039f", new StringMemory("&Omicron;"));
        HTML_ENTITIES.put("\u03a0", new StringMemory("&Pi;"));
        HTML_ENTITIES.put("\u03a1", new StringMemory("&Rho;"));
        HTML_ENTITIES.put("\u03a3", new StringMemory("&Sigma;"));
        HTML_ENTITIES.put("\u03a4", new StringMemory("&Tau;"));
        HTML_ENTITIES.put("\u03a5", new StringMemory("&Upsilon;"));
        HTML_ENTITIES.put("\u03a6", new StringMemory("&Phi;"));
        HTML_ENTITIES.put("\u03a7", new StringMemory("&Chi;"));
        HTML_ENTITIES.put("\u03a8", new StringMemory("&Psi;"));
        HTML_ENTITIES.put("\u03a9", new StringMemory("&Omega;"));
        HTML_ENTITIES.put("\u03b1", new StringMemory("&alpha;"));
        HTML_ENTITIES.put("\u03b2", new StringMemory("&beta;"));
        HTML_ENTITIES.put("\u03b3", new StringMemory("&gamma;"));
        HTML_ENTITIES.put("\u03b4", new StringMemory("&delta;"));
        HTML_ENTITIES.put("\u03b5", new StringMemory("&epsilon;"));
        HTML_ENTITIES.put("\u03b6", new StringMemory("&zeta;"));
        HTML_ENTITIES.put("\u03b7", new StringMemory("&eta;"));
        HTML_ENTITIES.put("\u03b8", new StringMemory("&theta;"));
        HTML_ENTITIES.put("\u03b9", new StringMemory("&iota;"));
        HTML_ENTITIES.put("\u03ba", new StringMemory("&kappa;"));
        HTML_ENTITIES.put("\u03bb", new StringMemory("&lambda;"));
        HTML_ENTITIES.put("\u03bc", new StringMemory("&mu;"));
        HTML_ENTITIES.put("\u03bd", new StringMemory("&nu;"));
        HTML_ENTITIES.put("\u03be", new StringMemory("&xi;"));
        HTML_ENTITIES.put("\u03bf", new StringMemory("&omicron;"));
        HTML_ENTITIES.put("\u03c0", new StringMemory("&pi;"));
        HTML_ENTITIES.put("\u03c1", new StringMemory("&rho;"));
        HTML_ENTITIES.put("\u03c2", new StringMemory("&sigmaf;"));
        HTML_ENTITIES.put("\u03c3", new StringMemory("&sigma;"));
        HTML_ENTITIES.put("\u03c4", new StringMemory("&tau;"));
        HTML_ENTITIES.put("\u03c5", new StringMemory("&upsilon;"));
        HTML_ENTITIES.put("\u03c6", new StringMemory("&phi;"));
        HTML_ENTITIES.put("\u03c7", new StringMemory("&chi;"));
        HTML_ENTITIES.put("\u03c8", new StringMemory("&psi;"));
        HTML_ENTITIES.put("\u03c9", new StringMemory("&omega;"));
        HTML_ENTITIES.put("\u03d1", new StringMemory("&thetasym;"));
        HTML_ENTITIES.put("\u03d2", new StringMemory("&upsih;"));
        HTML_ENTITIES.put("\u03d6", new StringMemory("&piv;"));
        HTML_ENTITIES.put("\u2002", new StringMemory("&ensp;"));
        HTML_ENTITIES.put("\u2003", new StringMemory("&emsp;"));
        HTML_ENTITIES.put("\u2009", new StringMemory("&thinsp;"));
        HTML_ENTITIES.put("\u200c", new StringMemory("&zwnj;"));
        HTML_ENTITIES.put("\u200d", new StringMemory("&zwj;"));
        HTML_ENTITIES.put("\u200e", new StringMemory("&lrm;"));
        HTML_ENTITIES.put("\u200f", new StringMemory("&rlm;"));
        HTML_ENTITIES.put("\u2013", new StringMemory("&ndash;"));
        HTML_ENTITIES.put("\u2014", new StringMemory("&mdash;"));
        HTML_ENTITIES.put("\u2018", new StringMemory("&lsquo;"));
        HTML_ENTITIES.put("\u2019", new StringMemory("&rsquo;"));
        HTML_ENTITIES.put("\u201a", new StringMemory("&sbquo;"));
        HTML_ENTITIES.put("\u201c", new StringMemory("&ldquo;"));
        HTML_ENTITIES.put("\u201d", new StringMemory("&rdquo;"));
        HTML_ENTITIES.put("\u201e", new StringMemory("&bdquo;"));
        HTML_ENTITIES.put("\u2020", new StringMemory("&dagger;"));
        HTML_ENTITIES.put("\u2021", new StringMemory("&Dagger;"));
        HTML_ENTITIES.put("\u2022", new StringMemory("&bull;"));
        HTML_ENTITIES.put("\u2026", new StringMemory("&hellip;"));
        HTML_ENTITIES.put("\u2030", new StringMemory("&permil;"));
        HTML_ENTITIES.put("\u2032", new StringMemory("&prime;"));
        HTML_ENTITIES.put("\u2033", new StringMemory("&Prime;"));
        HTML_ENTITIES.put("\u2039", new StringMemory("&lsaquo;"));
        HTML_ENTITIES.put("\u203a", new StringMemory("&rsaquo;"));
        HTML_ENTITIES.put("\u203e", new StringMemory("&oline;"));
        HTML_ENTITIES.put("\u2044", new StringMemory("&frasl;"));
        HTML_ENTITIES.put("\u20ac", new StringMemory("&euro;"));
        HTML_ENTITIES.put("\u2111", new StringMemory("&image;"));
        HTML_ENTITIES.put("\u2118", new StringMemory("&weierp;"));
        HTML_ENTITIES.put("\u211c", new StringMemory("&real;"));
        HTML_ENTITIES.put("\u2122", new StringMemory("&trade;"));
        HTML_ENTITIES.put("\u2135", new StringMemory("&alefsym;"));
        HTML_ENTITIES.put("\u2190", new StringMemory("&larr;"));
        HTML_ENTITIES.put("\u2191", new StringMemory("&uarr;"));
        HTML_ENTITIES.put("\u2192", new StringMemory("&rarr;"));
        HTML_ENTITIES.put("\u2193", new StringMemory("&darr;"));
        HTML_ENTITIES.put("\u2194", new StringMemory("&harr;"));
        HTML_ENTITIES.put("\u21b5", new StringMemory("&crarr;"));
        HTML_ENTITIES.put("\u21d0", new StringMemory("&lArr;"));
        HTML_ENTITIES.put("\u21d1", new StringMemory("&uArr;"));
        HTML_ENTITIES.put("\u21d2", new StringMemory("&rArr;"));
        HTML_ENTITIES.put("\u21d3", new StringMemory("&dArr;"));
        HTML_ENTITIES.put("\u21d4", new StringMemory("&hArr;"));
        HTML_ENTITIES.put("\u2200", new StringMemory("&forall;"));
        HTML_ENTITIES.put("\u2202", new StringMemory("&part;"));
        HTML_ENTITIES.put("\u2203", new StringMemory("&exist;"));
        HTML_ENTITIES.put("\u2205", new StringMemory("&empty;"));
        HTML_ENTITIES.put("\u2207", new StringMemory("&nabla;"));
        HTML_ENTITIES.put("\u2208", new StringMemory("&isin;"));
        HTML_ENTITIES.put("\u2209", new StringMemory("&notin;"));
        HTML_ENTITIES.put("\u220b", new StringMemory("&ni;"));
        HTML_ENTITIES.put("\u220f", new StringMemory("&prod;"));
        HTML_ENTITIES.put("\u2211", new StringMemory("&sum;"));
        HTML_ENTITIES.put("\u2212", new StringMemory("&minus;"));
        HTML_ENTITIES.put("\u2217", new StringMemory("&lowast;"));
        HTML_ENTITIES.put("\u221a", new StringMemory("&radic;"));
        HTML_ENTITIES.put("\u221d", new StringMemory("&prop;"));
        HTML_ENTITIES.put("\u221e", new StringMemory("&infin;"));
        HTML_ENTITIES.put("\u2220", new StringMemory("&ang;"));
        HTML_ENTITIES.put("\u2227", new StringMemory("&and;"));
        HTML_ENTITIES.put("\u2228", new StringMemory("&or;"));
        HTML_ENTITIES.put("\u2229", new StringMemory("&cap;"));
        HTML_ENTITIES.put("\u222a", new StringMemory("&cup;"));
        HTML_ENTITIES.put("\u222b", new StringMemory("&int;"));
        HTML_ENTITIES.put("\u2234", new StringMemory("&there4;"));
        HTML_ENTITIES.put("\u223c", new StringMemory("&sim;"));
        HTML_ENTITIES.put("\u2245", new StringMemory("&cong;"));
        HTML_ENTITIES.put("\u2248", new StringMemory("&asymp;"));
        HTML_ENTITIES.put("\u2260", new StringMemory("&ne;"));
        HTML_ENTITIES.put("\u2261", new StringMemory("&equiv;"));
        HTML_ENTITIES.put("\u2264", new StringMemory("&le;"));
        HTML_ENTITIES.put("\u2265", new StringMemory("&ge;"));
        HTML_ENTITIES.put("\u2282", new StringMemory("&sub;"));
        HTML_ENTITIES.put("\u2283", new StringMemory("&sup;"));
        HTML_ENTITIES.put("\u2284", new StringMemory("&nsub;"));
        HTML_ENTITIES.put("\u2286", new StringMemory("&sube;"));
        HTML_ENTITIES.put("\u2287", new StringMemory("&supe;"));
        HTML_ENTITIES.put("\u2295", new StringMemory("&oplus;"));
        HTML_ENTITIES.put("\u2297", new StringMemory("&otimes;"));
        HTML_ENTITIES.put("\u22a5", new StringMemory("&perp;"));
        HTML_ENTITIES.put("\u22c5", new StringMemory("&sdot;"));
        HTML_ENTITIES.put("\u2308", new StringMemory("&lceil;"));
        HTML_ENTITIES.put("\u2309", new StringMemory("&rceil;"));
        HTML_ENTITIES.put("\u230a", new StringMemory("&lfloor;"));
        HTML_ENTITIES.put("\u230b", new StringMemory("&rfloor;"));
        HTML_ENTITIES.put("\u2329", new StringMemory("&lang;"));
        HTML_ENTITIES.put("\u232a", new StringMemory("&rang;"));
        HTML_ENTITIES.put("\u25ca", new StringMemory("&loz;"));
        HTML_ENTITIES.put("\u2660", new StringMemory("&spades;"));
        HTML_ENTITIES.put("\u2663", new StringMemory("&clubs;"));
        HTML_ENTITIES.put("\u2665", new StringMemory("&hearts;"));
        HTML_ENTITIES.put("\u2666", new StringMemory("&diams;"));
        HTML_SPECIALCHARS = new ArrayMemory();
        HTML_SPECIALCHARS.put("<", new StringMemory("&lt;"));
        HTML_SPECIALCHARS.put(">", new StringMemory("&gt;"));
        HTML_SPECIALCHARS.put("&", new StringMemory("&amp;"));
        ForeachIterator iterator = HTML_ENTITIES.foreachIterator(false, false);
        while (iterator.next()) {
            HTML_SPECIALCHARS.refOfIndex(iterator.getValue()).assign(iterator.getKey().toString());
        }
    }

    static class MyGZIPOutputStream
    extends GZIPOutputStream {
        public MyGZIPOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        public void setLevel(int level) {
            this.def.setLevel(level);
        }
    }
}

