/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.effect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.effect.Effect;

public class ChainableEffect {
    private final Effect effect;
    private Method inputMethod;
    private final BooleanProperty disabled = new SimpleBooleanProperty(false);

    public ChainableEffect(Effect effect) {
        if (effect == null) {
            throw new IllegalArgumentException("Effect for chaining must not be null");
        }
        this.effect = effect;
        try {
            this.inputMethod = effect.getClass().getMethod("setInput", Effect.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.inputMethod = effect.getClass().getMethod("setContentInput", Effect.class);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("Effect for chaining must implement the setInput method", e);
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Creating chainable effects requires a reflection capable security environment", e);
        }
    }

    public ChainableEffect setInput(ChainableEffect chainableEffect) {
        try {
            this.inputMethod.invoke((Object)this.getEffect(), chainableEffect != null ? chainableEffect.getEffect() : null);
            return this;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Chainable effect does not support access rights for setInput", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to set the input for a chainable effect", e);
        }
    }

    public Effect getEffect() {
        return this.effect;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public BooleanProperty disabledProperty() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
    }
}

