/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control.markers;

import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.StrokeType;

public final class TabOutlineMarker
extends Group {
    private Bounds containerBounds;
    private Bounds referenceBounds;
    private boolean before;
    private final ObjectProperty<Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.ORANGE);
    private static final CssMetaData<TabOutlineMarker, Paint> FILL = new CssMetaData<TabOutlineMarker, Paint>("-fx-fill", PaintConverter.getInstance(), (Paint)Color.ORANGE){

        public boolean isSettable(TabOutlineMarker node) {
            return !node.fillProperty().isBound();
        }

        public StyleableProperty<Paint> getStyleableProperty(TabOutlineMarker node) {
            return (StyleableProperty)node.fillProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public TabOutlineMarker(Bounds containerBounds, Bounds referenceBounds, boolean before) {
        this.containerBounds = containerBounds;
        this.referenceBounds = referenceBounds;
        this.updateBounds(containerBounds, referenceBounds, before);
        this.getStyleClass().add((Object)"tab-outline-marker");
    }

    public void updateBounds(Bounds containerBounds, Bounds referenceBounds, boolean before) {
        if (containerBounds.equals(this.containerBounds) && referenceBounds.equals(this.referenceBounds) && before == this.before) {
            return;
        }
        this.containerBounds = containerBounds;
        this.referenceBounds = referenceBounds;
        this.before = before;
        Polyline pl = new Polyline();
        Bounds _referenceBounds = referenceBounds;
        _referenceBounds = before ? new BoundingBox(Math.max(0.0, _referenceBounds.getMinX() - _referenceBounds.getWidth() / 2.0), _referenceBounds.getMinY(), _referenceBounds.getWidth(), _referenceBounds.getHeight()) : new BoundingBox(Math.max(0.0, _referenceBounds.getMaxX() - _referenceBounds.getWidth() / 2.0), _referenceBounds.getMinY(), _referenceBounds.getWidth(), _referenceBounds.getHeight());
        pl.getPoints().addAll((Object[])new Double[]{0.0, _referenceBounds.getMaxY(), _referenceBounds.getMinX(), _referenceBounds.getMaxY(), _referenceBounds.getMinX(), _referenceBounds.getMinY(), _referenceBounds.getMaxX(), _referenceBounds.getMinY(), _referenceBounds.getMaxX(), _referenceBounds.getMaxY(), containerBounds.getMaxX(), _referenceBounds.getMaxY(), containerBounds.getMaxX(), containerBounds.getMaxY(), containerBounds.getMinX(), containerBounds.getMaxY(), containerBounds.getMinX(), _referenceBounds.getMaxY()});
        pl.strokeProperty().bind(this.fillProperty());
        pl.setStrokeWidth(3.0);
        pl.setStrokeType(StrokeType.INSIDE);
        this.getChildren().setAll((Object[])new Node[]{pl});
    }

    public ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public void setFill(Paint fill) {
        this.fillProperty().set((Object)fill);
    }

    public Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabOutlineMarker.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<TabOutlineMarker, Paint>> styleables = new ArrayList<CssMetaData<TabOutlineMarker, Paint>>(Group.getClassCssMetaData());
        styleables.add(FILL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

