/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.develnext.jphp.ext.javafx.classes.UXComboBoxBase;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXDatePicker")
public class UXDatePicker
extends UXComboBoxBase<DatePicker> {
    public UXDatePicker(Environment env, DatePicker wrappedObject) {
        super(env, wrappedObject);
    }

    public UXDatePicker(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new DatePicker();
    }

    @Reflection.Setter
    public void setFormat(String value) {
        ((DatePicker)this.getWrappedObject()).setConverter((StringConverter)new CustomConverter(value));
    }

    @Reflection.Getter
    public String getFormat() {
        StringConverter converter = ((DatePicker)this.getWrappedObject()).getConverter();
        if (converter instanceof CustomConverter) {
            return ((CustomConverter)converter).format;
        }
        return null;
    }

    @Override
    protected Memory getValue(Environment env) {
        if (((DatePicker)this.getWrappedObject()).getConverter() == null) {
            return StringMemory.valueOf(((LocalDate)((DatePicker)this.getWrappedObject()).getValue()).toString());
        }
        return StringMemory.valueOf(((DatePicker)this.getWrappedObject()).getConverter().toString(((DatePicker)this.getWrappedObject()).getValue()));
    }

    @Override
    @Reflection.Signature
    protected void setValue(Environment env, Memory value) {
        if (value.toString().isEmpty()) {
            ((DatePicker)this.getWrappedObject()).setValue(null);
        } else {
            try {
                if (((DatePicker)this.getWrappedObject()).getConverter() != null) {
                    ((DatePicker)this.getWrappedObject()).setValue(((DatePicker)this.getWrappedObject()).getConverter().fromString(value.toString()));
                } else {
                    ((DatePicker)this.getWrappedObject()).setValue((Object)LocalDate.parse(value.toString()));
                }
            }
            catch (DateTimeParseException e) {
                ((DatePicker)this.getWrappedObject()).setValue(null);
            }
        }
    }

    static class CustomConverter
    extends StringConverter<LocalDate> {
        private final DateTimeFormatter dateTimeFormatter;
        protected final String format;

        CustomConverter(String format) {
            this.format = format;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        }

        public String toString(LocalDate localDate) {
            if (localDate == null) {
                return "";
            }
            return this.dateTimeFormatter.format(localDate);
        }

        public LocalDate fromString(String dateString) {
            if (dateString == null || dateString.trim().isEmpty()) {
                return null;
            }
            return LocalDate.parse(dateString, this.dateTimeFormatter);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public TextField editor();

        @Reflection.Property
        public boolean showWeekNumbers();
    }
}

