/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.develnext.jphp.ext.javafx.classes.UXImage;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXClipboard")
public class UXClipboard
extends BaseObject {
    private static final Clipboard clipboard = Clipboard.getSystemClipboard();

    public UXClipboard(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private void __construct() {
    }

    @Reflection.Signature
    public static synchronized void clear() {
        clipboard.clear();
    }

    @Reflection.Signature
    public static synchronized boolean hasFiles() {
        return clipboard.hasFiles();
    }

    @Reflection.Signature
    public static synchronized boolean hasText() {
        return clipboard.hasString();
    }

    @Reflection.Signature
    public static synchronized boolean hasHtml() {
        return clipboard.hasHtml();
    }

    @Reflection.Signature
    public static synchronized boolean hasUrl() {
        return clipboard.hasUrl();
    }

    @Reflection.Signature
    public static synchronized boolean hasImage() {
        return clipboard.hasImage();
    }

    @Reflection.Signature
    public static synchronized String getUrl() {
        return clipboard.getUrl();
    }

    @Reflection.Signature
    public static synchronized String getHtml() {
        return clipboard.getHtml();
    }

    @Reflection.Signature
    public static synchronized String getText() {
        return clipboard.getString();
    }

    @Reflection.Signature
    public static synchronized List<File> getFiles() {
        return clipboard.getFiles();
    }

    @Reflection.Signature
    public static synchronized Image getImage() {
        return clipboard.getImage();
    }

    @Reflection.Signature
    public static synchronized void setContent(Environment env, ArrayMemory _content) {
        ClipboardContent content = new ClipboardContent();
        if (_content.containsKey("text")) {
            content.putString(_content.valueOfIndex("text").toString());
        }
        if (_content.containsKey("url")) {
            content.putUrl(_content.valueOfIndex("url").toString());
        }
        if (_content.containsKey("html")) {
            content.putHtml(_content.valueOfIndex("html").toString());
        }
        if (_content.containsKey("image")) {
            Memory image = _content.valueOfIndex("image");
            if (image.instanceOf(UXImage.class)) {
                content.putImage((Image)image.toObject(UXImage.class).getWrappedObject());
            } else {
                throw new IllegalArgumentException("The 'image' key should contain an instance of the image class");
            }
        }
        if (_content.containsKey("files")) {
            Memory files = _content.valueOfIndex("files");
            if (files.isTraversable()) {
                ForeachIterator iterator = files.getNewIterator(env);
                ArrayList<String> paths = new ArrayList<String>();
                while (iterator.next()) {
                    paths.add(iterator.getValue().toString());
                }
                content.putFilesByPath(paths);
            } else {
                throw new IllegalArgumentException("The 'files' key should contain a traversable value");
            }
        }
        clipboard.setContent((Map)content);
    }

    @Reflection.Signature
    public static synchronized void setText(String value) {
        ClipboardContent content = new ClipboardContent();
        content.putString(value);
        clipboard.setContent((Map)content);
    }
}

