/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.imageio.ImageIO;
import org.develnext.jphp.ext.javafx.classes.UXGraphicsContext;
import org.develnext.jphp.ext.javafx.classes.UXNode;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.invoke.Invoker;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXCanvas")
public class UXCanvas<T extends Canvas>
extends UXNode<Canvas> {
    public UXCanvas(Environment env, T wrappedObject) {
        super(env, wrappedObject);
    }

    public UXCanvas(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new Canvas();
    }

    @Override
    public T getWrappedObject() {
        return (T)((Canvas)super.getWrappedObject());
    }

    @Reflection.Signature
    public UXGraphicsContext getGraphicsContext(Environment env) {
        return new UXGraphicsContext(env, this.getWrappedObject().getGraphicsContext2D());
    }

    @Reflection.Signature
    public UXGraphicsContext gc(Environment env) {
        return this.getGraphicsContext(env);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    @Reflection.Signature
    public void writeImageAsync(final String format, final Memory outputStream, final @Reflection.Nullable Color transparentColor, final @Reflection.Nullable Invoker callback, final Environment env) throws IOException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SnapshotParameters param = new SnapshotParameters();
                param.setDepthBuffer(true);
                param.setFill((Paint)Color.TRANSPARENT);
                try {
                    final WritableImage image = UXCanvas.this.getWrappedObject().snapshot(param, null);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BufferedImage bImage = SwingFXUtils.fromFXImage((javafx.scene.image.Image)image, null);
                            if (transparentColor != null) {
                                final int markerRGB = new java.awt.Color((int)(transparentColor.getRed() * 255.0), (int)(transparentColor.getGreen() * 255.0), (int)(transparentColor.getBlue() * 255.0)).getRGB();
                                RGBImageFilter filter = new RGBImageFilter(){

                                    @Override
                                    public final int filterRGB(int x, int y, int rgb) {
                                        if (markerRGB == rgb) {
                                            return 0xFFFFFF & rgb;
                                        }
                                        return rgb;
                                    }
                                };
                                FilteredImageSource ip = new FilteredImageSource(bImage.getSource(), filter);
                                Image image1 = Toolkit.getDefaultToolkit().createImage(ip);
                                bImage = UXCanvas.imageToBufferedImage(image1);
                            }
                            try {
                                OutputStream out = Stream.getOutputStream(env, outputStream);
                                if (out == null) {
                                    throw new IOException();
                                }
                                ImageIO.write((RenderedImage)bImage, format, out);
                                if (callback != null) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.callAny(true);
                                        }
                                    });
                                }
                                Stream.closeStream(env, out);
                            }
                            catch (IOException e) {
                                if (callback != null) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.callAny(false);
                                        }
                                    });
                                }
                                env.wrapThrow(e);
                            }
                        }
                    }).start();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    @Reflection.Signature
    protected void setSize(double[] size) {
        if (size.length >= 2) {
            this.getWrappedObject().setWidth(size[0]);
            this.getWrappedObject().setHeight(size[1]);
        }
    }

    @Override
    protected double[] getSize() {
        return new double[]{this.getWrappedObject().getWidth(), this.getWrappedObject().getHeight()};
    }

    static interface WrappedInterface {
    }
}

