/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;

public class CommentToken
extends Token {
    private Kind kind;
    private boolean oldStyle;
    private String comment;

    public CommentToken(TokenMeta meta) {
        super(meta, TokenType.T_DOC_COMMENT);
        if (meta.getWord().startsWith("/**")) {
            this.kind = Kind.DOCTYPE;
        } else if (meta.getWord().startsWith("//")) {
            this.kind = Kind.SIMPLE;
        } else if (meta.getWord().startsWith("#")) {
            this.kind = Kind.SIMPLE;
            this.oldStyle = true;
        } else {
            this.kind = Kind.BLOCK;
        }
        this.comment = this.getComment();
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        switch (this.kind) {
            case DOCTYPE: {
                int i = 0;
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new StringReader(this.getWord().substring(3)));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("*")) {
                            line = line.substring(1).trim();
                        }
                        if (!line.isEmpty()) {
                            if (i != 0) {
                                builder.append("\n");
                            }
                            builder.append(line);
                            ++i;
                            continue;
                        }
                        builder.append("\n");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return builder.toString();
            }
        }
        if (this.oldStyle) {
            if (this.getWord().length() >= 1) {
                return this.getWord().substring(1);
            }
        } else if (this.getWord().length() >= 2) {
            return this.getWord().substring(2);
        }
        return "";
    }

    public static enum Kind {
        SIMPLE,
        BLOCK,
        DOCTYPE;


        public static Kind isComment(char ch, char prev_ch) {
            if (ch == '/' && prev_ch == '/') {
                return SIMPLE;
            }
            if (ch == '#') {
                return SIMPLE;
            }
            if (ch == '*' && prev_ch == '/') {
                return BLOCK;
            }
            return null;
        }
    }
}

