/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.NameGenerator;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BackslashExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;

public class UseGenerator
extends Generator<NamespaceUseStmtToken> {
    public UseGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    public void parseBody(NamespaceUseStmtToken use, Token current, ListIterator<Token> iterator, FulledNameToken prefix, NamespaceUseStmtToken.UseType prefixUseType) {
        boolean first = true;
        NamespaceUseStmtToken.UseType useType = prefixUseType;
        while (true) {
            Token name;
            Token next;
            if ((next = this.nextToken(iterator)) instanceof FunctionStmtToken) {
                if (!first && prefix == null || prefixUseType != NamespaceUseStmtToken.UseType.CLASS) {
                    this.unexpectedToken(next);
                }
                useType = NamespaceUseStmtToken.UseType.FUNCTION;
                next = this.nextToken(iterator);
            } else if (next instanceof ConstStmtToken) {
                if (!first && prefix == null || prefixUseType != NamespaceUseStmtToken.UseType.CLASS) {
                    this.unexpectedToken(next);
                }
                useType = NamespaceUseStmtToken.UseType.CONSTANT;
                next = this.nextToken(iterator);
            }
            use.setUseType(useType);
            if (prefix != null && next instanceof FulledNameToken && next.getMeta().getWord().startsWith("\\")) {
                this.unexpectedToken(new BackslashExprToken(TokenMeta.of("\\", next)), "identifier or function or const", false);
            }
            if ((name = this.analyzer.generator(NameGenerator.class).getToken(next, (ListIterator)iterator)) == null) {
                this.unexpectedToken(iterator.previous());
                return;
            }
            if (prefix == null) {
                use.setName((FulledNameToken)name);
            } else {
                ArrayList<NameToken> nameTokens = new ArrayList<NameToken>(prefix.getNames());
                nameTokens.addAll(((FulledNameToken)name).getNames());
                use.setName(new FulledNameToken(name.getMeta(), nameTokens));
            }
            Token token = this.nextToken(iterator);
            if (token instanceof AsStmtToken) {
                token = this.nextToken(iterator);
                if (token instanceof NameToken) {
                    use.setAs((NameToken)token);
                    token = this.nextToken(iterator);
                } else {
                    this.unexpectedToken(token);
                }
            } else if (this.isOpenedBrace(token, BraceExprToken.Kind.BLOCK)) {
                if (prefix == null) {
                    this.parseBody(use, current, iterator, (FulledNameToken)name, useType);
                    return;
                }
            } else if (token instanceof BackslashExprToken && this.isOpenedBrace(next = this.nextToken(iterator), BraceExprToken.Kind.BLOCK) && prefix == null) {
                this.parseBody(use, current, iterator, (FulledNameToken)name, useType);
                return;
            }
            NamespaceStmtToken namespace = this.analyzer.getNamespace();
            namespace.getUses().add(use);
            if (token instanceof CommaToken) {
                use = new NamespaceUseStmtToken(current.getMeta());
            } else {
                if (token instanceof SemicolonToken) break;
                if (prefix != null && this.isClosedBrace(token, BraceExprToken.Kind.BLOCK)) {
                    this.nextAndExpected(iterator, SemicolonToken.class);
                    break;
                }
                this.unexpectedToken(token);
            }
            first = false;
        }
    }

    @Override
    public NamespaceUseStmtToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof NamespaceUseStmtToken) {
            if (this.analyzer.getClazz() != null) {
                this.unexpectedToken(current);
            }
            NamespaceUseStmtToken use = (NamespaceUseStmtToken)current;
            this.parseBody(use, current, iterator, null, NamespaceUseStmtToken.UseType.CLASS);
            return use;
        }
        return null;
    }
}

