/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.NameGenerator;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;

public class NamespaceGenerator
extends Generator<NamespaceStmtToken> {
    public NamespaceGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    protected void processBody(NamespaceStmtToken namespace, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (next instanceof SemicolonToken) {
            List<Token> tree = this.analyzer.process(iterator);
            namespace.setTree(tree);
            namespace.setTokenRegistered(true);
        } else if (this.isOpenedBrace(next, BraceExprToken.Kind.BLOCK)) {
            boolean done = false;
            ArrayList<Token> tree = new ArrayList<Token>();
            while (iterator.hasNext()) {
                Token item = this.analyzer.processNext(iterator);
                if (this.isClosedBrace(item, BraceExprToken.Kind.BLOCK)) {
                    done = true;
                    break;
                }
                tree.add(item);
            }
            if (!done) {
                this.nextToken(iterator);
            }
            namespace.setTree(tree);
        } else {
            this.unexpectedToken(next);
        }
    }

    @Override
    public NamespaceStmtToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof NamespaceStmtToken) {
            NamespaceStmtToken result = (NamespaceStmtToken)current;
            Token name = this.analyzer.generator(NameGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator);
            result.setName((FulledNameToken)name);
            if (name == null) {
                iterator.previous();
            }
            this.analyzer.setNamespace(result);
            this.processBody(result, iterator);
            this.analyzer.setNamespace(NamespaceStmtToken.getDefault());
            return result;
        }
        return null;
    }
}

