/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.develnext.jphp.core.common.Separator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.FunctionGenerator;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.ThrowGenerator;
import org.develnext.jphp.core.syntax.generators.TryCatchGenerator;
import org.develnext.jphp.core.syntax.generators.manually.BodyGenerator;
import org.develnext.jphp.core.syntax.generators.manually.SimpleExprGenerator;
import org.develnext.jphp.core.tokenizer.token.BreakToken;
import org.develnext.jphp.core.tokenizer.token.ColonToken;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.OpenEchoTagToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.DollarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AmpersandRefToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.GetVarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableValueExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CaseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DefaultStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoRawToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ElseIfStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ElseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndforStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndforeachStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndifStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndswitchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndwhileStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForeachStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GlobalStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GotoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.IfStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.JumpStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.LabelStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.RequireStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ReturnStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StaticStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.SwitchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ThrowStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.WhileStmtToken;
import php.runtime.common.Messages;
import php.runtime.exceptions.FatalException;
import php.runtime.exceptions.support.ErrorType;

public class ExprGenerator
extends Generator<ExprStmtToken> {
    public ExprGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    public ExprStmtToken getInBraces(BraceExprToken.Kind kind, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (!this.isOpenedBrace(next, kind)) {
            this.unexpectedToken(next, BraceExprToken.Kind.toOpen(kind));
        }
        ExprStmtToken result = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, false, kind);
        if (!this.isClosedBrace(this.nextToken(iterator), kind)) {
            this.unexpectedToken(next, BraceExprToken.Kind.toClose(kind));
        }
        return result;
    }

    protected void processCase(CaseStmtToken result, ListIterator<Token> iterator) {
        Token next;
        this.analyzer.addScope();
        if (!(result instanceof DefaultStmtToken)) {
            next = this.nextToken(iterator);
            ExprStmtToken conditional = this.analyzer.generator(SimpleExprGenerator.class).getToken(next, iterator, Separator.COLON, null);
            if (conditional == null) {
                this.unexpectedToken(next);
            }
            result.setConditional(conditional);
        } else {
            next = this.nextToken(iterator);
            if (!this.isBreak(next) && !(next instanceof ColonToken)) {
                this.unexpectedToken(next);
            }
        }
        BodyStmtToken body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, true, EndswitchStmtToken.class, CaseStmtToken.class, DefaultStmtToken.class, BraceExprToken.class);
        result.setBody(body);
        result.setLocals(this.analyzer.removeScope().getVariables());
    }

    protected void processSwitch(SwitchStmtToken result, ListIterator<Token> iterator) {
        this.analyzer.addScope(false).setLevelForGoto(true);
        result.setValue(this.getInBraces(BraceExprToken.Kind.SIMPLE, iterator));
        if (result.getValue() == null) {
            this.unexpectedToken(iterator);
        }
        BodyStmtToken body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, false, false, EndswitchStmtToken.class);
        ArrayList<CaseStmtToken> cases = new ArrayList<CaseStmtToken>();
        for (ExprStmtToken instruction : body.getInstructions()) {
            if (instruction.isSingle()) {
                Token token = instruction.getSingle();
                if (token instanceof CaseStmtToken) {
                    cases.add((CaseStmtToken)token);
                    if (!(token instanceof DefaultStmtToken)) continue;
                    if (result.getDefaultCase() != null) {
                        this.unexpectedToken(token);
                    }
                    result.setDefaultCase((DefaultStmtToken)token);
                    continue;
                }
                this.unexpectedToken(token);
                continue;
            }
            this.unexpectedToken(instruction.getSingle());
        }
        if (body.isAlternativeSyntax()) {
            iterator.next();
        }
        result.setCases(cases);
        result.setLocal(this.analyzer.removeScope().getVariables());
    }

    protected void processIf(IfStmtToken result, ListIterator<Token> iterator) {
        this.analyzer.addScope(false);
        ExprStmtToken condition = this.getInBraces(BraceExprToken.Kind.SIMPLE, iterator);
        if (condition == null) {
            this.unexpectedToken(iterator);
        }
        BodyStmtToken body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, EndifStmtToken.class, ElseIfStmtToken.class);
        if (iterator.hasNext()) {
            Token next = this.nextToken(iterator);
            if (next instanceof ElseStmtToken) {
                BodyStmtToken bodyElse = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, false, false, EndifStmtToken.class);
                if (!bodyElse.getInstructions().isEmpty()) {
                    result.setElseBody(bodyElse);
                }
                if (bodyElse.isAlternativeSyntax()) {
                    iterator.next();
                }
            } else if (next instanceof ElseIfStmtToken) {
                next = new IfStmtToken(next.getMeta());
                BodyStmtToken bodyElse = this.analyzer.generator(BodyGenerator.class).getToken(next, iterator, EndifStmtToken.class);
                result.setElseBody(bodyElse);
            } else if (!(next instanceof EndifStmtToken)) {
                iterator.previous();
            }
        }
        result.setCondition(condition);
        result.setBody(body);
        result.setLocal(this.analyzer.removeScope().getVariables());
    }

    protected void processForeach(ForeachStmtToken result, ListIterator<Token> iterator) {
        BodyStmtToken body;
        ListExprToken listExprToken;
        Token single;
        ExprStmtToken eValue;
        ListExprToken listExpr;
        ExprStmtToken expr;
        this.analyzer.addScope(false).setLevelForGoto(true);
        Token next = this.nextToken(iterator);
        if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        if ((expr = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.AS, null)) == null) {
            this.unexpectedToken(iterator.previous());
        }
        result.setIterator(expr);
        next = this.nextToken(iterator);
        boolean reference = false;
        if (next instanceof AmpersandRefToken) {
            reference = true;
            next = this.nextToken(iterator);
        }
        if (next instanceof ListExprToken) {
            listExpr = this.analyzer.generator(SimpleExprGenerator.class).processSingleList(next, iterator);
            result.setValue(new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), listExpr));
        } else if (next instanceof VariableExprToken && this.nextTokenAndPrev(iterator) instanceof KeyValueExprToken) {
            iterator.next();
            result.setKey((VariableExprToken)next);
            result.setKeyReference(reference);
            next = this.nextToken(iterator);
            reference = false;
            if (next instanceof AmpersandRefToken) {
                reference = true;
                next = this.nextToken(iterator);
            }
            if (next instanceof ListExprToken) {
                listExpr = this.analyzer.generator(SimpleExprGenerator.class).processSingleList(next, iterator);
                result.setValue(new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), listExpr));
            } else {
                eValue = this.analyzer.generator(SimpleExprGenerator.class).getToken(next, iterator, null, BraceExprToken.Kind.SIMPLE);
                if (eValue == null) {
                    this.unexpectedToken(next);
                    return;
                }
                single = eValue.getLast();
                if (!(single instanceof VariableExprToken || single instanceof ArrayGetExprToken || single instanceof DynamicAccessExprToken || single instanceof StaticAccessExprToken && ((StaticAccessExprToken)single).isGetStaticField())) {
                    this.unexpectedToken(single);
                }
                result.setValue(eValue);
                result.setValueReference(reference);
            }
        } else {
            eValue = this.analyzer.generator(SimpleExprGenerator.class).getToken(next, iterator, null, BraceExprToken.Kind.SIMPLE);
            if (eValue == null) {
                this.unexpectedToken(next);
                return;
            }
            single = eValue.getLast();
            if (!(single instanceof VariableExprToken || single instanceof ArrayGetExprToken || single instanceof DynamicAccessExprToken || single instanceof StaticAccessExprToken && ((StaticAccessExprToken)single).isGetStaticField())) {
                this.unexpectedToken(single);
            }
            result.setValue(eValue);
            result.setValueReference(reference);
        }
        if (result.getValue().isSingle() && result.getValue().getSingle() instanceof ListExprToken && (listExprToken = (ListExprToken)result.getValue().getSingle()).getVariables().isEmpty()) {
            this.analyzer.getEnvironment().error(listExprToken.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_USE_EMPTY_LIST, new Object[0]);
        }
        if (!this.isClosedBrace(next = this.nextToken(iterator), BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, ")");
        }
        if ((body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, EndforeachStmtToken.class)) != null && body.isAlternativeSyntax()) {
            iterator.next();
        }
        result.setBody(body);
        Token last = result.getValue().getLast();
        if (this.analyzer.getFunction() != null) {
            if (result.getKey() != null) {
                this.analyzer.getFunction().variable(result.getKey()).setReference(true).setUnstable(true);
            }
            if (last instanceof VariableExprToken) {
                VariableExprToken variable = (VariableExprToken)last;
                this.analyzer.getFunction().variable(variable).setReference(true).setUnstable(true);
            }
        }
        if (last instanceof ArrayGetExprToken) {
            result.getValue().getTokens().set(result.getValue().getTokens().size() - 1, new ArrayGetRefExprToken((ArrayGetExprToken)last));
            result.getValue().updateAsmExpr(this.analyzer.getEnvironment(), this.analyzer.getContext());
        }
        if (result.getKey() != null) {
            this.analyzer.getScope().addVariable(result.getKey());
        }
        result.setLocal(this.analyzer.removeScope().getVariables());
    }

    protected void processFor(ForStmtToken result, ListIterator<Token> iterator) {
        ExprStmtToken iteratorExpr;
        ExprStmtToken conditionExpr;
        ExprStmtToken init;
        this.analyzer.addScope();
        Token next = this.nextToken(iterator);
        if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        ArrayList<ExprStmtToken> inits = new ArrayList<ExprStmtToken>();
        while ((init = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null)) != null) {
            inits.add(init);
            if (iterator.previous() instanceof SemicolonToken) {
                iterator.next();
                break;
            }
            iterator.next();
        }
        result.setInitLocal(this.analyzer.removeScope().getVariables());
        this.analyzer.addScope().setLevelForGoto(true);
        ArrayList<ExprStmtToken> conditions = new ArrayList<ExprStmtToken>();
        while ((conditionExpr = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null)) != null) {
            conditions.add(conditionExpr);
            if (iterator.previous() instanceof SemicolonToken) {
                iterator.next();
                break;
            }
            iterator.next();
        }
        ArrayList<ExprStmtToken> iterations = new ArrayList<ExprStmtToken>();
        while ((iteratorExpr = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA, BraceExprToken.Kind.SIMPLE)) != null) {
            iterations.add(iteratorExpr);
            if (this.isClosedBrace(iterator.previous(), BraceExprToken.Kind.SIMPLE)) {
                iterator.next();
                break;
            }
            iterator.next();
        }
        result.setIterationLocal(new HashSet<VariableExprToken>(this.analyzer.getScope().getVariables()));
        this.nextAndExpected(iterator, BraceExprToken.class);
        BodyStmtToken body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, EndforStmtToken.class);
        if (body != null && body.isAlternativeSyntax()) {
            iterator.next();
        }
        result.setInitExpr(inits);
        result.setConditionExpr(conditions);
        result.setIterationExpr(iterations);
        result.setBody(body);
        result.setLocal(this.analyzer.removeScope().getVariables());
    }

    protected void processWhile(WhileStmtToken result, ListIterator<Token> iterator) {
        BodyStmtToken body;
        this.analyzer.addScope().setLevelForGoto(true);
        ExprStmtToken condition = this.getInBraces(BraceExprToken.Kind.SIMPLE, iterator);
        if (condition == null) {
            this.unexpectedToken(iterator);
        }
        if ((body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), iterator, EndwhileStmtToken.class)) != null && body.isAlternativeSyntax()) {
            iterator.next();
        }
        result.setCondition(condition);
        result.setBody(body);
        result.setLocal(this.analyzer.removeScope().getVariables());
    }

    protected void processReturn(ReturnStmtToken result, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (next instanceof SemicolonToken) {
            result.setValue(null);
        } else {
            Token value = this.analyzer.generator(SimpleExprGenerator.class).getToken(next, (ListIterator)iterator);
            result.setValue((ExprStmtToken)value);
        }
    }

    protected void processDo(DoStmtToken result, ListIterator<Token> iterator) {
        this.analyzer.addScope().setLevelForGoto(true);
        Token body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator);
        result.setBody((BodyStmtToken)body);
        Token next = this.nextToken(iterator);
        if (next instanceof WhileStmtToken) {
            result.setCondition(this.getInBraces(BraceExprToken.Kind.SIMPLE, iterator));
            if (result.getCondition() == null) {
                this.unexpectedToken(iterator);
            }
            next = this.nextToken(iterator);
            result.setLocal(this.analyzer.removeScope().getVariables());
            if (next instanceof SemicolonToken) {
                return;
            }
        }
        this.unexpectedToken(next);
    }

    protected void processGlobal(GlobalStmtToken result, ListIterator<Token> iterator) {
        ArrayList<ValueExprToken> variables = new ArrayList<ValueExprToken>();
        Token next = this.nextToken(iterator);
        Token prev = null;
        while (true) {
            if (next instanceof VariableExprToken) {
                VariableExprToken variable = (VariableExprToken)next;
                this.analyzer.getScope().addVariable(variable);
                if (this.analyzer.getFunction() != null) {
                    this.analyzer.getFunction().variable(variable).setReference(true).setUnstable(true);
                }
                variables.add(variable);
            } else if (next instanceof DollarExprToken) {
                GetVarExprToken var = this.analyzer.generator(SimpleExprGenerator.class).processVarVar(next, this.nextTokenAndPrev(iterator), iterator);
                variables.add(var);
                next = var;
            } else if (next instanceof CommaToken) {
                if (!(prev instanceof VariableValueExprToken)) {
                    this.unexpectedToken(next);
                }
            } else {
                if (next instanceof SemicolonToken) {
                    if (prev instanceof VariableValueExprToken) break;
                    this.unexpectedToken(next);
                    break;
                }
                this.unexpectedToken(next);
            }
            prev = next;
            next = this.nextToken(iterator);
        }
        result.setVariables(variables);
    }

    protected List<StaticStmtToken> processStatic(StaticExprToken token, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (!(next instanceof VariableExprToken)) {
            iterator.previous();
            return null;
        }
        ArrayList<StaticStmtToken> list = new ArrayList<StaticStmtToken>();
        while (next instanceof VariableExprToken) {
            VariableExprToken variable = (VariableExprToken)next;
            this.analyzer.getScope().addVariable(variable);
            if (this.analyzer.getFunction() != null) {
                this.analyzer.getFunction().variable(variable).setReference(true).setUnstable(true);
                this.analyzer.getFunction().getStaticLocal().add(variable);
            }
            StaticStmtToken result = new StaticStmtToken(variable.getMeta());
            result.setVariable((VariableExprToken)next);
            next = this.nextToken(iterator);
            if (next instanceof AssignExprToken) {
                ExprStmtToken initValue = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null);
                if (this.nextTokenAndPrev(iterator) instanceof CommaToken) {
                    iterator.next();
                }
                result.setInitValue(initValue);
                list.add(result);
            } else {
                if (this.isBreak(next)) {
                    result.setInitValue(null);
                    list.add(result);
                    break;
                }
                if (next instanceof CommaToken) {
                    result.setInitValue(null);
                    list.add(result);
                } else {
                    this.unexpectedToken(next);
                }
            }
            next = this.nextToken(iterator);
        }
        return list;
    }

    protected void processGoto(GotoStmtToken result, ListIterator<Token> iterator) {
        NameToken token = this.nextAndExpected(iterator, NameToken.class);
        if (token.getClass() != NameToken.class) {
            this.unexpectedToken(token);
        }
        this.nextAndExpected(iterator, SemicolonToken.class);
        result.setLevel(this.analyzer.getScope().getGotoLevel());
        result.setLabel(token);
    }

    protected void processJump(JumpStmtToken result, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        long level = 1L;
        if (next instanceof IntegerExprToken) {
            level = ((IntegerExprToken)next).getValue();
            if (level < 1L) {
                throw new FatalException(Messages.ERR_OPERATOR_ACCEPTS_ONLY_POSITIVE.fetch(result.getWord()), result.toTraceInfo(this.analyzer.getContext()));
            }
            next = this.nextToken(iterator);
        }
        result.setLevel((int)level);
        if (!(next instanceof SemicolonToken)) {
            this.unexpectedToken(next);
        }
    }

    protected void processImport(RequireStmtToken result, ListIterator<Token> iterator) {
        ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.SEMICOLON, null);
        result.setValue(value);
        if (value == null) {
            this.unexpectedToken(iterator);
        }
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().setDynamicLocal(true);
            this.analyzer.getFunction().setCallsExist(true);
        }
    }

    public void processEcho(EchoStmtToken result, ListIterator<Token> iterator) {
        ExprStmtToken argument;
        ArrayList<ExprStmtToken> arguments = new ArrayList<ExprStmtToken>();
        do {
            Token prev;
            if ((argument = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null)) != null) {
                arguments.add(argument);
            }
            if (this.isBreak(prev = iterator.previous())) {
                iterator.next();
                break;
            }
            iterator.next();
        } while (argument != null);
        result.setArguments(arguments);
    }

    protected List<Token> processSimpleExpr(Token current, ListIterator<Token> iterator) {
        ExprStmtToken token = this.analyzer.generator(SimpleExprGenerator.class).getToken(current, iterator, Separator.SEMICOLON, null);
        return token.getTokens();
    }

    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator, Class<? extends Token> ... endTokens) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        do {
            if (current instanceof EndStmtToken || this.isTokenClass(current, endTokens)) {
                boolean doBreak = true;
                if (!this.isTokenClass(current, endTokens)) {
                    this.unexpectedToken(current);
                }
                if (current instanceof BraceExprToken) {
                    if (((BraceExprToken)current).isOpened()) {
                        doBreak = false;
                    } else if (!this.isClosedBrace(current, BraceExprToken.Kind.BLOCK)) {
                        this.unexpectedToken(current);
                    }
                }
                if (doBreak) break;
            }
            if (current instanceof EchoRawToken) {
                tokens.add(current);
                break;
            }
            if (current instanceof OpenEchoTagToken) {
                OpenEchoTagToken result = (OpenEchoTagToken)current;
                result.setValue((ExprStmtToken)this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator));
                tokens.add(current);
                break;
            }
            if (this.isOpenedBrace(current, BraceExprToken.Kind.BLOCK)) {
                BodyStmtToken body = this.analyzer.generator(BodyGenerator.class).getToken(current, iterator, EndforStmtToken.class);
                tokens.add(body);
                break;
            }
            if (current instanceof RequireStmtToken) {
                this.processImport((RequireStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof EchoStmtToken) {
                this.processEcho((EchoStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof IfStmtToken) {
                this.processIf((IfStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof ReturnStmtToken) {
                this.processReturn((ReturnStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof ForStmtToken) {
                this.processFor((ForStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof ForeachStmtToken) {
                this.processForeach((ForeachStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof WhileStmtToken) {
                this.processWhile((WhileStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof DoStmtToken) {
                this.processDo((DoStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof CaseStmtToken) {
                this.processCase((CaseStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof SwitchStmtToken) {
                this.processSwitch((SwitchStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof ThrowStmtToken) {
                tokens.add(this.analyzer.generator(ThrowGenerator.class).getToken(current, (ListIterator)iterator));
                break;
            }
            if (current instanceof TryStmtToken) {
                tokens.add(this.analyzer.generator(TryCatchGenerator.class).getToken(current, (ListIterator)iterator));
                break;
            }
            if (current instanceof GlobalStmtToken) {
                this.processGlobal((GlobalStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof JumpStmtToken) {
                this.processJump((JumpStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof BreakToken) {
                tokens.add(current);
                break;
            }
            if (current instanceof GotoStmtToken) {
                this.processGoto((GotoStmtToken)current, iterator);
                tokens.add(current);
                break;
            }
            if (current instanceof SemicolonToken) {
                tokens.add(current);
                break;
            }
            if (current instanceof FunctionStmtToken) {
                FunctionStmtToken token = this.analyzer.generator(FunctionGenerator.class).getToken(current, iterator, true);
                token.setStatic(false);
                if (token.getName() == null) {
                    ClosureStmtToken closure = new ClosureStmtToken(token.getMeta());
                    closure.setFunction(token);
                    closure.setOwnerClass(this.analyzer.getClazz());
                    tokens.add(closure);
                    this.analyzer.registerClosure(closure);
                    List<Token> tmp = this.processSimpleExpr(current, iterator);
                    tokens.addAll(tmp);
                    break;
                }
                tokens.add(token);
                this.analyzer.registerFunction(token);
                break;
            }
            if (current instanceof ExprToken) {
                List<StaticStmtToken> result;
                if (current instanceof StaticExprToken && (result = this.processStatic((StaticExprToken)current, iterator)) != null) {
                    tokens.addAll(result);
                    break;
                }
                if (current.getClass() == NameToken.class && iterator.hasNext() && this.nextTokenAndPrev(iterator) instanceof ColonToken) {
                    LabelStmtToken labelStmtToken = new LabelStmtToken(current.getMeta());
                    tokens.add(labelStmtToken);
                    iterator.next();
                    this.analyzer.getScope().addLabel(labelStmtToken);
                    break;
                }
                if (this.isClosedBrace(current, BraceExprToken.Kind.BLOCK)) {
                    if (endTokens == null || this.isTokenClass(current, endTokens)) break;
                    this.unexpectedToken(current);
                    break;
                }
                List<Token> tmp = this.processSimpleExpr(current, iterator);
                tokens.addAll(tmp);
                break;
            }
            if (!(current instanceof ClassStmtToken)) {
                if (current instanceof CommentToken) {
                    tokens.add(current);
                    break;
                }
                if (tokens.isEmpty()) break;
                this.unexpectedToken(current);
                break;
            }
            this.unexpectedToken(current);
        } while (current != null);
        if (tokens.isEmpty()) {
            return null;
        }
        ExprStmtToken stmtToken = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), tokens);
        return stmtToken;
    }

    @Override
    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator) {
        return this.getToken(current, iterator, null);
    }
}

