/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.develnext.jphp.core.common.Separator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.ConstGenerator;
import org.develnext.jphp.core.syntax.generators.FunctionGenerator;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.NameGenerator;
import org.develnext.jphp.core.syntax.generators.manually.SimpleExprGenerator;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ParentExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AbstractStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassVarStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExtendsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FinalStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ImplementsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.InsteadofStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.InterfaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.PrivateStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ProtectedStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.PublicStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TraitStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.VarStmtToken;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.exceptions.ParseException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.reflection.ClassEntity;

public class ClassGenerator
extends Generator<ClassStmtToken> {
    private static final Class<? extends Token>[] modifiers = new Class[]{PrivateStmtToken.class, ProtectedStmtToken.class, PublicStmtToken.class, StaticExprToken.class, FinalStmtToken.class, AbstractStmtToken.class, VarStmtToken.class, ConstStmtToken.class};

    public ClassGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    protected void processName(ClassStmtToken result, ListIterator<Token> iterator) {
        Token name = this.nextTokenSensitive(iterator, new Class[0]);
        if (name instanceof NameToken) {
            result.setName((NameToken)name);
            if (name instanceof ParentExprToken) {
                this.unexpectedToken(name);
            }
        } else {
            this.unexpectedToken(name, (Object)TokenType.T_STRING);
        }
    }

    protected void _processImplements(Token token, ClassStmtToken result, ListIterator<Token> iterator) {
        ImplementsStmtToken implement = new ImplementsStmtToken(token.getMeta());
        Token prev = null;
        ArrayList<FulledNameToken> names = new ArrayList<FulledNameToken>();
        while (true) {
            if ((token = this.nextToken(iterator)) instanceof NameToken) {
                names.add(this.analyzer.getRealName((NameToken)token));
            } else if (token instanceof CommaToken) {
                if (!(prev instanceof NameToken)) {
                    this.unexpectedToken(token);
                }
            } else {
                if (this.isOpenedBrace(token, BraceExprToken.Kind.BLOCK)) break;
                this.unexpectedToken(token);
            }
            prev = token;
        }
        iterator.previous();
        implement.setNames(names);
        result.setImplement(implement);
    }

    protected void processExtends(ClassStmtToken result, ListIterator<Token> iterator) {
        Token token = this.nextToken(iterator);
        if (token instanceof ExtendsStmtToken) {
            if (result.isTrait()) {
                this.unexpectedToken(token);
            }
            if (result.isInterface()) {
                this._processImplements(token, result, iterator);
            } else {
                ExtendsStmtToken extend = (ExtendsStmtToken)token;
                Token what = this.analyzer.generator(NameGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator);
                if (what == null) {
                    this.unexpectedToken(extend);
                }
                extend.setName(this.analyzer.getRealName((NameToken)what));
                result.setExtend(extend);
            }
        } else {
            iterator.previous();
        }
    }

    protected void processImplements(ClassStmtToken result, ListIterator<Token> iterator) {
        this.checkUnexpectedEnd(iterator);
        Token token = iterator.next();
        if (token instanceof ImplementsStmtToken) {
            if (result.isTrait()) {
                this.unexpectedToken(token);
            }
            if (result.isInterface()) {
                this.unexpectedToken(token, "extends");
            }
            this._processImplements(token, result, iterator);
        } else {
            iterator.previous();
        }
    }

    protected List<ClassVarStmtToken> processProperty(ClassStmtToken clazz, VariableExprToken current, List<Token> modifiers, ListIterator<Token> iterator) {
        Token next = current;
        VariableExprToken prev = null;
        LinkedHashSet<VariableExprToken> variables = new LinkedHashSet<VariableExprToken>();
        ArrayList<ExprStmtToken> initValues = new ArrayList<ExprStmtToken>();
        ExprStmtToken initValue = null;
        ArrayList<ClassVarStmtToken> result = new ArrayList<ClassVarStmtToken>();
        Modifier modifier = Modifier.PUBLIC;
        boolean isStatic = false;
        for (Token token : modifiers) {
            if (token instanceof PrivateStmtToken) {
                modifier = Modifier.PRIVATE;
                continue;
            }
            if (token instanceof ProtectedStmtToken) {
                modifier = Modifier.PROTECTED;
                continue;
            }
            if (!(token instanceof StaticExprToken)) continue;
            isStatic = true;
        }
        while (true) {
            if (next instanceof VariableExprToken) {
                if (!variables.add((VariableExprToken)next)) {
                    throw new ParseException(Messages.ERR_IDENTIFIER_X_ALREADY_USED.fetch(next.getWord()), next.toTraceInfo(this.analyzer.getContext()));
                }
                initValues.add(null);
            } else if (next instanceof CommaToken) {
                if (!(prev instanceof VariableExprToken)) {
                    this.unexpectedToken(next);
                }
            } else if (next instanceof AssignExprToken) {
                if (!(prev instanceof VariableExprToken)) {
                    this.unexpectedToken(next);
                }
                initValue = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null);
                initValues.set(initValues.size() - 1, initValue);
                if (iterator.hasPrevious() && this.isBreak(iterator.previous())) {
                    iterator.next();
                    break;
                }
                if (iterator.hasNext()) {
                    iterator.next();
                }
            } else if (next instanceof SemicolonToken) {
                if (prev instanceof VariableExprToken) break;
                this.unexpectedToken(next);
                break;
            }
            prev = next;
            next = this.nextToken(iterator);
        }
        int i = 0;
        for (VariableExprToken variable : variables) {
            ClassVarStmtToken classVar = new ClassVarStmtToken(variable.getMeta());
            classVar.setModifier(modifier);
            classVar.setStatic(isStatic);
            classVar.setValue((ExprStmtToken)initValues.get(i));
            classVar.setVariable(variable);
            classVar.setClazz(clazz);
            result.add(classVar);
            ++i;
        }
        return result;
    }

    protected void processUse(ClassStmtToken result, ListIterator<Token> iterator) {
        if (result.isInterface()) {
            this.unexpectedToken(iterator.previous());
        }
        Token prev = null;
        ArrayList<FulledNameToken> uses = new ArrayList<FulledNameToken>();
        while (true) {
            Token token;
            if ((token = this.nextToken(iterator)) instanceof NameToken) {
                uses.add(this.analyzer.getRealName((NameToken)token));
            } else if (token instanceof CommaToken) {
                if (!(prev instanceof NameToken)) {
                    this.unexpectedToken(token);
                }
            } else {
                if (token instanceof SemicolonToken) break;
                if (this.isOpenedBrace(token, BraceExprToken.Kind.BLOCK)) {
                    this.processBlock(result, (NameToken)uses.get(0), iterator);
                    break;
                }
                this.unexpectedToken(token);
            }
            prev = token;
        }
        result.getUses().addAll(uses);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processBlock(ClassStmtToken result, NameToken firstTraitName, ListIterator<Token> iterator) {
        if (result.isInterface()) {
            this.unexpectedToken(iterator.previous());
        }
        do {
            NameToken cls;
            Token next;
            Token what;
            NameToken methodName;
            NameToken className = this.nextAndExpectedSensitive(iterator, NameToken.class);
            Token token = this.nextToken(iterator);
            if (token instanceof StaticAccessExprToken) {
                className = this.analyzer.getRealName(className);
                Token nextTokenSensitive = this.nextTokenSensitive(iterator, new Class[0]);
                if (!(nextTokenSensitive instanceof NameToken)) {
                    this.unexpectedToken(nextTokenSensitive);
                    return;
                }
                methodName = (NameToken)nextTokenSensitive;
            } else {
                iterator.previous();
                methodName = className;
                if (className.getClass() != NameToken.class) {
                    this.unexpectedToken(className);
                }
                className = firstTraitName;
            }
            if ((what = this.nextToken(iterator)) instanceof AsStmtToken) {
                Token one = this.nextTokenSensitive(iterator, PrivateStmtToken.class, ProtectedStmtToken.class, PublicStmtToken.class, FinalStmtToken.class, StaticExprToken.class);
                if (one instanceof NameToken) {
                    result.addAlias(className.getName(), methodName.getName(), null, ((NameToken)one).getName());
                } else if (this.isTokenClass(one, PrivateStmtToken.class, ProtectedStmtToken.class, PublicStmtToken.class)) {
                    Modifier modifier = Modifier.PRIVATE;
                    if (one instanceof ProtectedStmtToken) {
                        modifier = Modifier.PROTECTED;
                    } else if (one instanceof PublicStmtToken) {
                        modifier = Modifier.PUBLIC;
                    }
                    token = this.nextTokenSensitive(iterator, new Class[0]);
                    String name = null;
                    if (token instanceof NameToken) {
                        NameToken two = (NameToken)token;
                        if (two.getClass() != NameToken.class) {
                            this.unexpectedToken(two);
                        }
                        name = two.getName();
                    } else if (token instanceof SemicolonToken) {
                        iterator.previous();
                    } else {
                        this.unexpectedToken(token);
                    }
                    result.addAlias(className.getName(), methodName.getName(), modifier, name);
                } else {
                    this.unexpectedToken(one);
                }
                this.nextAndExpected(iterator, SemicolonToken.class);
                continue;
            }
            if (!(what instanceof InsteadofStmtToken)) {
                this.unexpectedToken(what);
                continue;
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<String> namesLower = new HashSet<String>();
            do {
                cls = this.nextAndExpected(iterator, NameToken.class);
                if (!namesLower.add((cls = this.analyzer.getRealName(cls)).getName().toLowerCase())) {
                    this.analyzer.getEnvironment().error(iterator.previous().toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_TRAIT_MULTIPLE_RULE, methodName.getName(), cls.getName());
                }
                names.add(cls.getName());
            } while ((next = this.nextToken(iterator)) instanceof CommaToken || !(next instanceof SemicolonToken));
            if (result.addReplacement(className.getName(), methodName.getName(), names)) continue;
            this.analyzer.getEnvironment().error(iterator.previous().toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_TRAIT_MULTIPLE_RULE, methodName.getName(), cls.getName());
        } while (!this.isClosedBrace(this.nextTokenAndPrev(iterator), BraceExprToken.Kind.BLOCK));
        iterator.next();
    }

    protected void processBody(ClassStmtToken result, ListIterator<Token> iterator) {
        BraceExprToken brace;
        this.analyzer.setClazz(result);
        Token token = this.nextToken(iterator);
        if (token instanceof BraceExprToken && (brace = (BraceExprToken)token).isBlockOpened()) {
            ArrayList<ConstStmtToken> constants = new ArrayList<ConstStmtToken>();
            ArrayList<MethodStmtToken> methods = new ArrayList<MethodStmtToken>();
            ArrayList<ClassVarStmtToken> properties = new ArrayList<ClassVarStmtToken>();
            ArrayList<Token> modifiers = new ArrayList<Token>();
            CommentToken lastComment = null;
            while (iterator.hasNext()) {
                Token current = iterator.next();
                if (current instanceof ExprStmtToken) {
                    this.unexpectedToken(current, "expression");
                }
                if (current instanceof ConstStmtToken) {
                    if (!modifiers.isEmpty()) {
                        this.unexpectedToken((Token)modifiers.get(0));
                    }
                    if (result.isTrait()) {
                        this.unexpectedToken(current);
                    }
                    Token one = this.analyzer.generator(ConstGenerator.class).getToken(current, (ListIterator)iterator);
                    ((ConstStmtToken)one).setClazz(result);
                    ((ConstStmtToken)one).setDocComment(lastComment);
                    lastComment = null;
                    constants.add((ConstStmtToken)one);
                    modifiers.clear();
                    continue;
                }
                if (this.isTokenClass(current, ClassGenerator.modifiers)) {
                    for (Token token2 : modifiers) {
                        if (token2.getType() != current.getType()) continue;
                        this.unexpectedToken(current);
                    }
                    modifiers.add(current);
                    continue;
                }
                if (current instanceof VariableExprToken) {
                    if (result.isInterface()) {
                        this.analyzer.getEnvironment().error(result.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_INTERFACE_MAY_NOT_INCLUDE_VARS, new Object[0]);
                    }
                    for (Token token3 : modifiers) {
                        if (!this.isTokenClass(token3, FinalStmtToken.class, AbstractStmtToken.class)) continue;
                        this.unexpectedToken(token3);
                    }
                    List<ClassVarStmtToken> vars = this.processProperty(result, (VariableExprToken)current, modifiers, iterator);
                    if (lastComment != null) {
                        for (ClassVarStmtToken var : vars) {
                            var.setDocComment(lastComment);
                        }
                        lastComment = null;
                    }
                    properties.addAll(vars);
                    modifiers.clear();
                    continue;
                }
                if (current instanceof FunctionStmtToken) {
                    Token function = this.analyzer.generator(FunctionGenerator.class).getToken(current, (ListIterator)iterator);
                    if (function == null) {
                        this.nextToken(iterator);
                        this.unexpectedToken(iterator);
                    }
                    MethodStmtToken methodStmtToken = new MethodStmtToken((FunctionStmtToken)function);
                    methodStmtToken.setClazz(result);
                    methodStmtToken.setDocComment(lastComment);
                    lastComment = null;
                    for (Token modifier : modifiers) {
                        if (modifier instanceof AbstractStmtToken) {
                            methodStmtToken.setAbstract(true);
                            continue;
                        }
                        if (modifier instanceof StaticExprToken) {
                            methodStmtToken.setStatic(true);
                            continue;
                        }
                        if (modifier instanceof FinalStmtToken) {
                            methodStmtToken.setFinal(true);
                            continue;
                        }
                        if (modifier instanceof PublicStmtToken) {
                            if (methodStmtToken.getModifier() != null) {
                                this.unexpectedToken(modifier);
                            }
                            methodStmtToken.setModifier(Modifier.PUBLIC);
                            continue;
                        }
                        if (modifier instanceof PrivateStmtToken) {
                            if (methodStmtToken.getModifier() != null) {
                                this.unexpectedToken(modifier);
                            }
                            methodStmtToken.setModifier(Modifier.PRIVATE);
                            continue;
                        }
                        if (!(modifier instanceof ProtectedStmtToken)) continue;
                        if (methodStmtToken.getModifier() != null) {
                            this.unexpectedToken(modifier);
                        }
                        methodStmtToken.setModifier(Modifier.PROTECTED);
                    }
                    if (methodStmtToken.getModifier() == null) {
                        methodStmtToken.setModifier(Modifier.PUBLIC);
                    }
                    methods.add(methodStmtToken);
                    modifiers.clear();
                    continue;
                }
                if (current instanceof NamespaceUseStmtToken) {
                    this.processUse(result, iterator);
                    lastComment = null;
                    continue;
                }
                if (this.isClosedBrace(current, BraceExprToken.Kind.BLOCK)) break;
                if (current instanceof CommentToken) {
                    lastComment = (CommentToken)current;
                    continue;
                }
                this.unexpectedToken(current);
            }
            result.setConstants(constants);
            result.setMethods(methods);
            result.setProperties(properties);
            this.analyzer.setClazz(null);
            return;
        }
        this.unexpectedToken(token, "{");
    }

    protected ClassStmtToken processDefine(Token current, ListIterator<Token> iterator) {
        ClassStmtToken result = null;
        if (this.isTokenClass(current, FinalStmtToken.class, AbstractStmtToken.class)) {
            Token next = this.nextToken(iterator);
            if (next instanceof ClassStmtToken) {
                result = (ClassStmtToken)next;
                result.setInterface(false);
                result.setAbstract(current instanceof AbstractStmtToken);
                result.setFinal(current instanceof FinalStmtToken);
            } else if (next instanceof InterfaceStmtToken || next instanceof TraitStmtToken) {
                this.unexpectedToken(current);
            } else if (next instanceof AbstractStmtToken || next instanceof FinalStmtToken) {
                this.unexpectedToken(next);
            } else {
                iterator.previous();
            }
        }
        if (current instanceof ClassStmtToken) {
            result = (ClassStmtToken)current;
        } else if (current instanceof InterfaceStmtToken) {
            result = new ClassStmtToken(current.getMeta());
            result.setInterface(true);
        } else if (current instanceof TraitStmtToken) {
            result = new ClassStmtToken(current.getMeta());
            result.setClassType(ClassEntity.Type.TRAIT);
        }
        if (result != null) {
            iterator.previous();
            if (result.isFinal() || result.isAbstract()) {
                iterator.previous();
            }
            if (iterator.hasPrevious()) {
                Token tk = iterator.previous();
                if (tk instanceof CommentToken) {
                    result.setDocComment((CommentToken)tk);
                }
                iterator.next();
            }
            if (result.isFinal() || result.isAbstract()) {
                iterator.next();
            }
            iterator.next();
        }
        return result;
    }

    @Override
    public ClassStmtToken getToken(Token current, ListIterator<Token> iterator) {
        ClassStmtToken result = this.processDefine(current, iterator);
        if (result != null) {
            if (this.analyzer.getClazz() != null) {
                this.unexpectedToken(current);
            }
            this.analyzer.setClazz(result);
            result.setNamespace(this.analyzer.getNamespace());
            this.processName(result, iterator);
            this.processExtends(result, iterator);
            this.processImplements(result, iterator);
            this.processBody(result, iterator);
            this.analyzer.setClazz(null);
        }
        return result;
    }
}

