/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import java.util.Collection;
import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.helper.ClosureEntity;

public class ClosureValueCompiler
extends BaseExprCompiler<ClosureStmtToken> {
    public ClosureValueCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    protected void writePushUses(Collection<ArgumentStmtToken> parameters) {
        if (parameters.isEmpty()) {
            this.add(new InsnNode(1));
            this.expr.stackPush(Memory.Type.REFERENCE);
            return;
        }
        this.expr.writePushSmallInt(parameters.size());
        this.add(new TypeInsnNode(189, Type.getInternalName(Memory.class)));
        this.expr.stackPop();
        this.expr.stackPush(Memory.Type.REFERENCE);
        int i = 0;
        for (ArgumentStmtToken param : parameters) {
            this.expr.writePushDup();
            this.expr.writePushSmallInt(i);
            LocalVariable local = this.method.getLocalVariable(param.getName().getName());
            if (local == null) {
                this.expr.writePushNull();
            } else {
                this.expr.writeVarLoad(local);
            }
            if (!param.isReference()) {
                this.expr.writePopBoxing(true);
            }
            this.add(new InsnNode(83));
            this.expr.stackPop();
            this.expr.stackPop();
            this.expr.stackPop();
            ++i;
        }
    }

    protected void writeContext() {
        if (this.method.clazz.getClassContext() != null && this.method.clazz.getClassContext().isTrait()) {
            this.expr.writePushEnv();
            this.expr.writeSysDynamicCall(Environment.class, "__getMacroClass", Memory.class, new Class[0]);
            this.expr.writePopString();
        } else if (this.method.clazz.getClassContext() != null) {
            this.expr.writePushConstString(this.method.clazz.getClassContext().getFulledName());
        } else if (this.method.clazz.isSystem()) {
            this.expr.writePushConstNull();
        } else {
            this.expr.writePushConstString(((ClassEntity)this.method.clazz.getEntity()).getName());
        }
    }

    @Override
    public void write(ClosureStmtToken closure, boolean returnValue) {
        if (returnValue) {
            ClosureEntity entity = this.compiler.getModule().findClosure(closure.getId());
            boolean thisExists = closure.getFunction().isThisExists();
            boolean staticExists = closure.getFunction().isStaticExists();
            if (closure.getFunction().getUses().isEmpty() && !thisExists && !staticExists && closure.getFunction().getStaticLocal().isEmpty()) {
                this.expr.writePushEnv();
                this.expr.writePushConstString(this.compiler.getModule().getInternalName());
                this.expr.writePushConstInt((int)entity.getId());
                this.expr.writeSysDynamicCall(Environment.class, "__getSingletonClosure", Memory.class, String.class, Integer.TYPE);
            } else {
                this.add(new TypeInsnNode(187, entity.getInternalName()));
                this.expr.stackPush(Memory.Type.REFERENCE);
                this.expr.writePushDup();
                this.expr.writePushEnv();
                this.expr.writePushEnv();
                this.expr.writePushConstString(this.compiler.getModule().getInternalName());
                this.expr.writePushConstInt((int)entity.getId());
                this.expr.writeSysDynamicCall(Environment.class, "__getClosure", ClassEntity.class, String.class, Integer.TYPE);
                if (thisExists) {
                    this.expr.writePushThis();
                } else {
                    this.expr.writePushNull();
                }
                this.writeContext();
                this.writePushUses(closure.getFunction().getUses());
                this.add(new MethodInsnNode(183, entity.getInternalName(), "<init>", Type.getMethodDescriptor(Type.getType(Void.TYPE), Type.getType(Environment.class), Type.getType(ClassEntity.class), Type.getType(Memory.class), Type.getType(String.class), Type.getType(Memory[].class)), false));
                this.expr.stackPop();
                this.expr.stackPop();
                this.expr.stackPop();
                this.expr.stackPop();
                this.expr.stackPop();
                this.expr.stackPop();
                this.expr.writeSysStaticCall(ObjectMemory.class, "valueOf", Memory.class, IObject.class);
            }
            this.expr.setStackPeekAsImmutable();
        }
    }
}

