/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.operator;

import org.develnext.jphp.core.compiler.common.misc.StackItem;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.operator.InstanceofExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import php.runtime.Memory;
import php.runtime.OperatorUtils;

public class InstanceOfCompiler
extends BaseExprCompiler<InstanceofExprToken> {
    public InstanceOfCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    protected void pushName(StackItem R) {
        NameToken name = null;
        if (R.getToken() instanceof NameToken) {
            name = this.compiler.getAnalyzer().getRealName((NameToken)R.getToken());
        }
        if (name == null) {
            this.expr.writePush(R);
            this.expr.writePopString();
            this.expr.writePushDupLowerCase();
        } else {
            this.expr.writePushConstString(name.getName());
            this.expr.writePushConstString(name.getName().toLowerCase());
        }
    }

    @Override
    public void write(InstanceofExprToken instanceOf, boolean returnValue) {
        boolean isInvert;
        if (this.expr.stackEmpty(true)) {
            this.expr.unexpectedToken(instanceOf);
        }
        StackItem R = this.expr.stackPop();
        StackItem L = this.expr.stackPop();
        boolean bl = isInvert = !R.isKnown();
        if (!R.isKnown() && !L.isKnown() && R.getLevel() > L.getLevel()) {
            isInvert = false;
        }
        if (isInvert) {
            this.pushName(R);
            this.expr.writePopString();
            this.expr.writePushDupLowerCase();
            this.expr.writePush(L);
            if (this.expr.stackPeek().isConstant()) {
                this.expr.unexpectedToken(instanceOf);
            }
            this.expr.writePopBoxing();
            this.expr.writeSysStaticCall(OperatorUtils.class, "instanceOfRight", Boolean.TYPE, String.class, String.class, Memory.class);
            this.expr.writePopAll(1);
        } else {
            this.expr.writePush(L);
            if (this.expr.stackPeek().isConstant()) {
                this.expr.unexpectedToken(instanceOf);
            }
            this.expr.writePopBoxing();
            this.pushName(R);
            this.expr.writeSysDynamicCall(Memory.class, "instanceOf", Boolean.TYPE, String.class, String.class);
        }
        if (!returnValue) {
            this.expr.writePopAll(1);
        }
    }
}

