/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.MethodStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CatchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.BaseException;
import php.runtime.lang.exception.BaseBaseException;

public class TryCatchCompiler
extends BaseStatementCompiler<TryStmtToken> {
    public TryCatchCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(TryStmtToken token) {
        if (token.getBody() == null || token.getBody().getInstructions().isEmpty()) {
            if (token.getFinally() != null) {
                this.expr.write(BodyStmtToken.class, token.getFinally());
            }
            return;
        }
        this.expr.writeDefineVariables(token.getLocal());
        LabelNode tryStart = this.expr.writeLabel(this.node, token.getMeta().getStartLine());
        LabelNode tryEnd = new LabelNode();
        LabelNode catchStart = new LabelNode();
        LabelNode catchEnd = new LabelNode();
        LabelNode returnLabel = new LabelNode();
        this.method.node.tryCatchBlocks.add(0, new TryCatchBlockNode(tryStart, tryEnd, catchStart, Type.getInternalName(BaseBaseException.class)));
        if (token.getFinally() != null) {
            this.method.getTryStack().push(new MethodStmtCompiler.TryCatchItem(token, returnLabel));
        }
        this.expr.write(BodyStmtToken.class, token.getBody());
        if (token.getFinally() != null) {
            this.method.getTryStack().pop();
        }
        this.add(tryEnd);
        this.add(new JumpInsnNode(167, catchEnd));
        this.add(catchStart);
        LocalVariable exception = this.method.addLocalVariable("~catch~" + this.method.nextStatementIndex(BaseException.class), catchStart, BaseBaseException.class);
        exception.setEndLabel(catchEnd);
        this.expr.makeVarStore(exception);
        LabelNode nextCatch = null;
        int i = 0;
        int size = token.getCatches().size();
        LocalVariable local = null;
        LabelNode catchFail = new LabelNode();
        for (CatchStmtToken _catch : token.getCatches()) {
            if (nextCatch != null) {
                this.add(nextCatch);
            }
            nextCatch = i == size - 1 ? catchFail : new LabelNode();
            local = this.method.getLocalVariable(_catch.getVariable().getName());
            this.expr.writePushEnv();
            this.expr.writeVarLoad(exception);
            this.expr.writePushConstString(_catch.getException().toName());
            this.expr.writePushConstString(_catch.getException().toName().toLowerCase());
            this.expr.writeSysDynamicCall(Environment.class, "__throwCatch", Memory.class, BaseBaseException.class, String.class, String.class);
            this.expr.writeVarAssign(local, _catch.getVariable(), true, false);
            this.expr.writePopBoolean();
            this.add(new JumpInsnNode(153, nextCatch));
            this.expr.stackPop();
            this.expr.write(BodyStmtToken.class, _catch.getBody());
            this.add(new JumpInsnNode(167, catchEnd));
            ++i;
        }
        this.add(catchFail);
        if (token.getFinally() != null) {
            this.expr.write(BodyStmtToken.class, token.getFinally());
        }
        this.expr.makeVarLoad(exception);
        this.add(new InsnNode(191));
        this.add(catchEnd);
        if (token.getFinally() != null) {
            LabelNode skip = new LabelNode();
            this.add(new JumpInsnNode(167, skip));
            this.add(returnLabel);
            this.expr.write(BodyStmtToken.class, token.getFinally());
            if (this.method.getTryStack().empty()) {
                LocalVariable retVar = this.method.getOrAddLocalVariable("~result~", null, Memory.class);
                this.expr.writeVarLoad(retVar);
                this.add(new InsnNode(176));
                this.expr.stackPop();
            } else {
                this.add(new JumpInsnNode(167, this.method.getTryStack().peek().getReturnLabel()));
            }
            this.add(skip);
            this.expr.write(BodyStmtToken.class, token.getFinally());
        }
        this.expr.writeUndefineVariables(token.getLocal());
        this.method.prevStatementIndex(BaseBaseException.class);
    }
}

