/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.JumpItem;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.stmt.BreakStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ContinueStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.JumpStmtToken;
import org.objectweb.asm.tree.JumpInsnNode;
import php.runtime.common.Messages;
import php.runtime.exceptions.support.ErrorType;

public class JumpCompiler
extends BaseStatementCompiler<JumpStmtToken> {
    public JumpCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(JumpStmtToken token) {
        int level = token.getLevel();
        JumpItem jump = this.method.getJump(level);
        if (jump == null) {
            this.env.error(token.toTraceInfo(this.compiler.getContext()), ErrorType.E_COMPILE_ERROR, level == 1 ? Messages.ERR_CANNOT_JUMP.fetch(new Object[0]) : Messages.ERR_CANNOT_JUMP_TO_LEVEL.fetch(level), new Object[0]);
            return;
        }
        if (token instanceof ContinueStmtToken) {
            this.add(new JumpInsnNode(167, jump.continueLabel));
        } else if (token instanceof BreakStmtToken) {
            this.add(new JumpInsnNode(167, jump.breakLabel));
        }
    }
}

