/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.GetVarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GlobalStmtToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.exceptions.CriticalException;

public class GlobalDefinitionCompiler
extends BaseStatementCompiler<GlobalStmtToken> {
    public GlobalDefinitionCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(GlobalStmtToken token) {
        for (ValueExprToken variable : token.getVariables()) {
            if (variable instanceof VariableExprToken) {
                LocalVariable local = this.method.getLocalVariable(((VariableExprToken)variable).getName());
                assert (local != null);
                this.expr.writePushEnv();
                this.expr.writePushConstString(local.name);
                this.expr.writeSysDynamicCall(Environment.class, "getOrCreateGlobal", Memory.class, String.class);
                this.expr.writeVarStore(local, false, false);
                continue;
            }
            if (!(variable instanceof GetVarExprToken)) continue;
            BaseExprCompiler compiler = (BaseExprCompiler)this.expr.getCompiler(GetVarExprToken.class);
            if (compiler == null) {
                throw new CriticalException("Cannot find a valid compiler for " + GetVarExprToken.class.getName());
            }
            compiler.write((GetVarExprToken)variable, true);
            this.expr.writePushEnv();
            Memory name = this.expr.writeExpression(((GetVarExprToken)variable).getName(), true, true, true);
            if (name != null) {
                this.expr.writePushConstString(name.toString());
            } else {
                this.expr.writePopString();
            }
            this.expr.writeSysDynamicCall(Environment.class, "getOrCreateGlobal", Memory.class, String.class);
            this.expr.writeSysDynamicCall(Memory.class, "assign", Memory.class, Memory.class);
            this.expr.writePopAll(1);
        }
    }
}

